% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-tables.R
\name{BayesTools_model_tables}
\alias{BayesTools_model_tables}
\alias{model_summary_table}
\alias{runjags_estimates_table}
\alias{runjags_inference_table}
\alias{JAGS_estimates_table}
\alias{JAGS_inference_table}
\alias{JAGS_summary_table}
\alias{runjags_estimates_empty_table}
\alias{runjags_inference_empty_table}
\alias{stan_estimates_table}
\title{Create BayesTools model tables}
\usage{
model_summary_table(
  model,
  model_description = NULL,
  title = NULL,
  footnotes = NULL,
  warnings = NULL,
  remove_spike_0 = TRUE,
  short_name = FALSE,
  formula_prefix = TRUE
)

runjags_estimates_table(
  fit,
  transformations = NULL,
  title = NULL,
  footnotes = NULL,
  warnings = NULL,
  conditional = FALSE,
  remove_spike_0 = TRUE,
  transform_orthonormal = FALSE,
  formula_prefix = TRUE,
  remove_inclusion = FALSE,
  remove_parameters = NULL
)

runjags_inference_table(
  fit,
  title = NULL,
  footnotes = NULL,
  warnings = NULL,
  formula_prefix = TRUE
)

JAGS_estimates_table(
  fit,
  transformations = NULL,
  title = NULL,
  footnotes = NULL,
  warnings = NULL,
  conditional = FALSE,
  remove_spike_0 = TRUE,
  transform_orthonormal = FALSE,
  formula_prefix = TRUE,
  remove_inclusion = FALSE,
  remove_parameters = NULL
)

JAGS_inference_table(
  fit,
  title = NULL,
  footnotes = NULL,
  warnings = NULL,
  formula_prefix = TRUE
)

JAGS_summary_table(
  model,
  model_description = NULL,
  title = NULL,
  footnotes = NULL,
  warnings = NULL,
  remove_spike_0 = TRUE,
  short_name = FALSE,
  formula_prefix = TRUE
)

runjags_estimates_empty_table(title = NULL, footnotes = NULL, warnings = NULL)

runjags_inference_empty_table(title = NULL, footnotes = NULL, warnings = NULL)

stan_estimates_table(
  fit,
  transformations = NULL,
  title = NULL,
  footnotes = NULL,
  warnings = NULL
)
}
\arguments{
\item{model}{model object containing a list of \code{priors}
and \code{inference} object, The \code{inference} must be a
named list with information about the model: model number
\code{m_number}, marginal likelihood \code{marglik}, prior and
posterior probability \code{prior_prob} and \code{post_prob},
and model inclusion Bayes factor \code{inclusion_BF}}

\item{model_description}{named list with additional description
to be added to the table}

\item{title}{title to be added to the table}

\item{footnotes}{footnotes to be added to the table}

\item{warnings}{warnings to be added to the table}

\item{remove_spike_0}{whether prior distributions equal to spike
at 0 should be removed from the \code{prior_list}}

\item{short_name}{whether the prior distribution names should be
shortened. Defaults to \code{FALSE}.}

\item{formula_prefix}{whether the parameter prefix from formula should
be printed. Defaults to \code{TRUE}.}

\item{fit}{runjags model fit}

\item{transformations}{named list of transformations to be applied
to specific parameters}

\item{conditional}{summarizes estimates conditional on being included
in the model for spike and slab priors. Defaults to \code{FALSE}.}

\item{transform_orthonormal}{whether factors with orthonormal prior
distributions should be transformed to differences from the grand
mean}

\item{remove_inclusion}{whether estimates of the inclusion probabilities
should be excluded from the summary table. Defaults to \code{FALSE}.}

\item{remove_parameters}{parameters to be removed from the summary. Defaults
to \code{NULL}, i.e., including all parameters.}
}
\value{
\code{model_summary_table} returns a table with
overview of the fitted model, \code{runjags_estimates_table} returns
a table with MCMC estimates, and \code{runjags_estimates_empty_table}
returns an empty estimates table. All of the tables are objects of
class 'BayesTools_table'.
}
\description{
Creates model summary based on a model objects or
provides estimates table for a runjags fit.
}
\seealso{
\link{BayesTools_ensemble_tables}
}
