% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsFisher-functions.R
\name{transX_fisher}
\alias{transX_fisher}
\title{Design matrix of \code{bsFisher(), bsPolar(), bsSpike()}}
\usage{
transX_fisher(Xlin, df, degree, delta)
}
\arguments{
\item{Xlin}{A numeric vector representing the linear predictor values.}

\item{df}{An integer scalar specifying the total number of basis functions (degrees of freedom).}

\item{degree}{An integer scalar giving the polynomial degree of the B-spline.}

\item{delta}{A numeric scalar that extends the lower and upper boundary knots
by \code{delta} to reduce boundary effects.}
}
\value{
A numeric matrix containing the B-spline basis expansion
of \code{Xlin} with \code{df} columns.
}
\description{
The \pkg{nimble} function that makes \eqn{X'\theta} to B-spline basis design matrix.
}
\details{
The function determines internal knots based on quantiles of \code{Xlin}
and extends the boundary knots by a small \code{delta}.
The resulting basis matrix can be directly used as an input design matrix
for spline-based link functions.

This function is intended for internal development purposes and is not designed for direct use by end users.
}
\seealso{
\code{\link{bsFisher}}, \code{\link{bsPolar}}, \code{\link{bsSpike}}, \code{\link{predict.bsimSpline}}
}
