% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BayesPiecewiseHazardTrt}
\alias{BayesPiecewiseHazardTrt}
\title{Samples from the PEH Cox model with a patient covariate vector.}
\usage{
BayesPiecewiseHazardTrt(Y, I1, Trt, Poi, B)
}
\arguments{
\item{Y}{Vector of event or censoring times.}

\item{I1}{Vector of event indicators.}

\item{Trt}{Vector containing patient treatment/control assignment.}

\item{Poi}{Prior mean number of split points.}

\item{B}{Number of iterations for MCMC.}
}
\value{
Returns a list containing posterior samples of (1) the split point locations, (2) the log-hazards at each split point, (3) the number of split points, (4) the variance parameter for the log-hazard values, (5) the treatment coefficient, (6) the mean restricted survivial time of the control therapy, (7) the mean restricted survival time of the treatment therapy.
}
\description{
Samples from the Piecewise Linear Log-Hazard (PLLH) Cox model and returns a list containing posterior parameters and posterior restricted mean survival.
}
\examples{
##Generate Data
Y=rweibull(20,4,1)
I=rbinom(20,1,.5)
Trt=rbinom(20,1,.5)
##Hyperparameter for number of split points
Poi=5
##Number of iterations for MCMC
B=200
BayesPiecewiseHazardTrt( Y, I,Trt, Poi,  B)
}
