% Generated by roxygen2 (4.0.0): do not edit by hand
\name{DPdensityHODC}
\alias{DPdensityHODC}
\title{Hierachical Ordered Density Clustering (HODC) for Dirichlet Process Mixture Model Fitting}
\description{
This function implements the HODC algorithm for posterior density samples by a Dirichlet process mixture (DPM) of normals model which is implemented by function "DPdensity" in R package \strong{DPpackages}.  
}

\usage{
DPdensityHODC(v, pvalue)
}
\arguments{
\item{pvalue}{a vector of p-values obtained from large scale statistical hypothesis testing}

\item{v}{the number of poseterior sample saved}
}
\value{
a list of density clustering results by the HODC algorithm 
\describe{
\item{mean}{a list containing posterior samples for the mean of unimportant and important clusters 
\describe{
\item{mu0}{a vector of length "v" containing posterior samples for the mean of the unimportant cluster}
\item{mu1}{a vector of length "v" containing posterior samples for the mean of the important cluster}
}
}
\item{variance}{a list containing posterior samples of the variance of the unimportant and the important clusters
\describe{
\item{var0}{a vector of length "v" containing posterior samples for the variance of the unimportant cluster}
\item{var1}{a vector of length "v" containing posterior samples for the variance of the important cluster}
}
}
\item{probability}{a list containing the probabilities of unimportant and important clusters
\describe{
\item{pro0}{a vector of length "v" containing posterior samples for the probability of the unimportant cluster}
\item{pro1}{a vector of length "v" containing posterior samples for the probability of the important cluster}
}
}
\item{classification}{a binary (0/1) matrix of dimension "v" by length(pvalue) contianing posterior samples for two cluster classification results}
}
}

\references{
Yize Zhao, Jian Kang, Tianwei Yu (2014) A Bayesian nonparameteric model for selecting gene and gene subnetwork, Annals of Applied Statistics, in press. 

Zhou Lan, Jian Kang, Tianwei Yu, Yize Zhao, BayesNetDiscovery: an R package for network identifications via Bayesian nonparametric mixture models, working paper.
}
\author{
Zhou Lan, Jian Kang, Tianwei Yu and Yize Zhao
}

\details{
This function calls DPdensity to estimate the marginal density of the testing statistics \strong{r}, converted from p-values, using a mixture of normal densities without incoorporating the network information. Futhermore, it implements the HODC algorithm to classify density components into two clusters. We refer to them as the unimportant cluster and the important cluster, where the important cluster has a larger mean than the unimportant cluster. 
}
\examples{
###random make the density
rstat=c(rnorm(50,mean=1),rnorm(50,mean=2),rnorm(100,mean=4)
,rnorm(100,mean=8))
###transformed into pvalue
pvalue=pnorm(-rstat)
dpdensityHODC=DPdensityHODC(v=5,pvalue)
}

