% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F1_ComputeKLDs.R
\name{ComputeKLDs}
\alias{ComputeKLDs}
\title{Compute signed and symmetric Kullback-Leibler divergence}
\usage{
ComputeKLDs(tree, var0, vars, seq, pbar = TRUE)
}
\arguments{
\item{tree}{a \code{\linkS4class{ClusterTree}} object}

\item{var0}{the variable to have evidence absrobed}

\item{vars}{the variables to have divergence computed}

\item{seq}{a \code{vector} of numeric values as the evidences}

\item{pbar}{\code{logical(1)} whether to show progress bar}
}
\value{
a \code{data.frame} of the divergence
}
\description{
Compute signed and symmetric Kullback-Leibler divergence of variables over a spectrum of evidence
}
\details{
Compute signed and symmetric Kullback-Leibler divergence of variables over a spectrum of evidence.
The signed and symmetric Kullback-Leibler divergence is also known as Jeffery's signed information (JSI) for
continuous variables.
}
\examples{
\dontrun{
data(liver)
cst <- ClusterTreeCompile(dag=liver$dag, node.class=liver$node.class)
models <- LocalModelCompile(data=liver$data, dag=liver$dag, node.class=liver$node.class)
tree.init <- ElimTreeInitialize(tree=cst$tree.graph, 
                                dag=cst$dag, 
                                model=models, 
                                node.sets=cst$cluster.sets, 
                                node.class=cst$node.class)
tree.init.p <- PropagateDBN(tree.init)
klds <- ComputeKLDs(tree=tree.init.p, var0="Nr1i3", 
                    vars=setdiff(tree.init.p@node, "Nr1i3"),
                    seq=seq(-3,3,0.5))
head(klds)
}
}
\author{
Han Yu
}
