% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesMultMeta.R
\name{BayesMultMeta}
\alias{BayesMultMeta}
\title{Interface for the BayesMultMeta class}
\usage{
BayesMultMeta(X, U, N, burn_in, likelihood, prior, algorithm_version, d = NULL)
}
\arguments{
\item{X}{A \eqn{p \times n} matrix which contains \eqn{n} observation vectors
of dimension \eqn{p}}

\item{U}{A \eqn{pn \times pn} block-diagonal matrix which contains the
covariance matrices of observation vectors.}

\item{N}{Length of the generated Markov chain.}

\item{burn_in}{Number of burn-in samples}

\item{likelihood}{Likelihood to use. It currently supports "normal" and
"t".}

\item{prior}{Prior to use. It currently supports "reference" and
"jeffrey".}

\item{algorithm_version}{One of "mu" or "Psi". Both algorithms samples the
same quantities.}

\item{d}{Degrees of freedom for the t-distribution when the "t" option is
used for the likelihood.}
}
\value{
a BayesMultMeta class which contains simulations from the MCMC
inference procedure as well as many of the input parameters. The elements
'psi' and 'mu' in the list contains simulations from the posterior
distribution. All other elements are input parameters to the class.
}
\description{
The BayesMultMeta package implements two methods of constructing Markov
chains to assess the posterior distribution of the model parameters, namely
the overall mean vector \eqn{\mathbf{\mu}} and the between-study covariance matrix
\eqn{\mathbf{\Psi}}, of the generalized marginal multivariate random effects models.
The Bayesian inference procedures are performed when the model parameters are
endowed with the Berger and Bernardo reference prior
\insertCite{berger1992development}{BayesMultMeta} and the Jeffreys prior
\insertCite{1946RSPSA.186..453J}{BayesMultMeta}. This is achieved by
constructing Markov chains using the Metropolis-Hastings algorithms developed
in \insertCite{bodnar2021objective}{BayesMultMeta}. The convergence
properties of the generated Markov chains are investigated by the rank plots
and the split-\eqn{\hat{R}} estimate based on the rank normalization, which are
proposed in \insertCite{vehtari2021rank}{BayesMultMeta}.
}
\examples{
dataREM<-mvmeta::hyp
# Observation matrix X
X<-t(cbind(dataREM$sbp,dataREM$dbp))
p<-nrow(X)  # model dimension
n<-ncol(X)  # sample size
# Matrix U
U<-matrix(0,n*p,n*p)
for (i_n in 1:n) {
  Use<-diag(c(dataREM$sbp_se[i_n],dataREM$dbp_se[i_n]))
  Corr_mat<-matrix(c(1,dataREM$rho[i_n],dataREM$rho[i_n],1),p,p)
  U[(p*(i_n-1)+1):(p*i_n),(p*(i_n-1)+1):(p*i_n)]<- Use\%*\%Corr_mat\%*\%Use
}

bmgmr_run <- BayesMultMeta(X, U, 1e2, burn_in = 100,
                   likelihood = "normal", prior="jeffrey",
                   algorithm_version = "mu")
summary(bmgmr_run)
plot(bmgmr_run)

}
\references{
\insertAllCited{}
}
