% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_hp.R
\name{print.HP}
\alias{print.HP}
\title{Print Values for HP fitted models}
\usage{
\method{print}{HP}(x, ...)
}
\arguments{
\item{x}{A \code{HP} or \code{ClosedHP} object, result of a call to hp() or hp_close() function.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A character vector with the details of a fitted \code{HP} or \code{ClosedHP} model.
}
\description{
Print details from a fitted \code{HP} or \code{ClosedHP} models and returns it invisibly.
}
\examples{
 ## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

## Selecting the exposure and death count of the 2010 male population ranging from 0 to 90 years old
USA2010 = USA[USA$Year == 2010,]
x = 0:90
Ex = USA2010$Ex.Male[x+1]
Dx = USA2010$Dx.Male[x+1]

## Fitting binomial model
fit = hp(x = x, Ex = Ex, Dx = Dx, M = 5000, bn = 0, thin = 10)
print(fit)

}
\seealso{
\code{\link[=print.DLM]{print.DLM()}}, \code{\link[=print.BLC]{print.BLC()}} and \code{\link[=print.PredBLC]{print.PredBLC()}} for \code{DLM}, \code{BLC} or \code{PredBLC} methods.
}
