% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_prior.R
\name{sample_prior}
\alias{sample_prior}
\title{Sample from prior distribution}
\usage{
sample_prior(n, n_items, priors = set_priors())
}
\arguments{
\item{n}{An integer specifying the number of samples to take.}

\item{n_items}{An integer specifying the number of items to be ranked.}

\item{priors}{An object of class "BayesMallowsPriors" returned from
\code{\link[=set_priors]{set_priors()}}.}
}
\value{
An object of class "BayesMallowsPriorSample", containing \code{n}
independent samples of \eqn{\alpha} and \eqn{\rho}.
}
\description{
Function to obtain samples from the prior distributions of the Bayesian
Mallows model. Intended to be given to \code{\link[=update_mallows]{update_mallows()}}.
}
\examples{
\dontrun{
# We can use a collection of particles from the prior distribution as
# initial values for the sequential Monte Carlo algorithm.
# Here we start by drawing 1000 particles from the priors, using default
# parameters.
prior_samples <- sample_prior(1000, ncol(sushi_rankings))
# Next, we provide the prior samples to update_mallws(), together
# with the first five rows of the sushi dataset
model1 <- update_mallows(
  model = prior_samples,
  new_data = setup_rank_data(sushi_rankings[1:5, ]))
plot(model1)

# We keep adding more data
model2 <- update_mallows(
  model = model1,
  new_data = setup_rank_data(sushi_rankings[6:10, ]))
plot(model2)

model3 <- update_mallows(
  model = model2,
  new_data = setup_rank_data(sushi_rankings[11:15, ]))
plot(model3)
}
}
\seealso{
Other modeling: 
\code{\link{burnin}()},
\code{\link{burnin<-}()},
\code{\link{compute_mallows}()},
\code{\link{compute_mallows_mixtures}()},
\code{\link{compute_mallows_sequentially}()},
\code{\link{update_mallows}()}
}
\concept{modeling}
