% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_top_k.R
\name{predict_top_k}
\alias{predict_top_k}
\title{Predict Top-k Rankings with Pairwise Preferences}
\usage{
predict_top_k(model_fit, burnin = model_fit$burnin, k = 3)
}
\arguments{
\item{model_fit}{An object of type \code{BayesMallows}, returned from
\code{\link[=compute_mallows]{compute_mallows()}}.}

\item{burnin}{A numeric value specifying the number of iterations to discard
as burn-in. Defaults to \code{model_fit$burnin}, and must be provided if
\code{model_fit$burnin} does not exist. See
\code{\link[=assess_convergence]{assess_convergence()}}.}

\item{k}{Integer specifying the k in top-\eqn{k}.}
}
\value{
A dataframe with columns \code{assessor}, \code{item}, and
\code{prob}, where each row states the probability that the given assessor
rates the given item among top-\eqn{k}.
}
\description{
Predict the posterior probability, per item, of being ranked among the
top-\eqn{k} for each assessor. This is useful when the data take the form of
pairwise preferences.
}
\examples{
set.seed(1)
# We use the example dataset with beach preferences. Se the documentation to
# compute_mallows for how to assess the convergence of the algorithm
# We need to save the augmented data, so setting this option to TRUE
model_fit <- compute_mallows(
  data = setup_rank_data(preferences = beach_preferences),
  compute_options = set_compute_options(
    nmc = 1000, burnin = 500, save_aug = TRUE))
# By default, the probability of being top-3 is plotted
# The default plot gives the probability for each assessor
plot_top_k(model_fit)
# We can also plot the probability of being top-5, for each item
plot_top_k(model_fit, k = 5)
# We get the underlying numbers with predict_top_k
probs <- predict_top_k(model_fit)
# To find all items ranked top-3 by assessors 1-3 with probability more than 80 \%,
# we do
subset(probs, assessor \%in\% 1:3 & prob > 0.8)

# We can also plot for clusters
model_fit <- compute_mallows(
  data = setup_rank_data(preferences = beach_preferences),
  model_options = set_model_options(n_clusters = 3),
  compute_options = set_compute_options(
    nmc = 1000, burnin = 500, save_aug = TRUE)
  )
# The modal ranking in general differs between clusters, but the plot still
# represents the posterior distribution of each user's augmented rankings.
plot_top_k(model_fit)
}
\seealso{
Other posterior quantities: 
\code{\link{assign_cluster}()},
\code{\link{compute_consensus}()},
\code{\link{compute_posterior_intervals}()},
\code{\link{heat_plot}()},
\code{\link{plot.BayesMallows}()},
\code{\link{plot.SMCMallows}()},
\code{\link{plot_elbow}()},
\code{\link{plot_top_k}()},
\code{\link{print.BayesMallows}()}
}
\concept{posterior quantities}
