% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{plot.BayesFBHborrow}
\alias{plot.BayesFBHborrow}
\title{Plot the MCMC results}
\usage{
\method{plot}{BayesFBHborrow}(x, x_lim, estimator = NULL, type = NULL, ...)
}
\arguments{
\item{x}{object of class "BayesFBHborrow" to be visualized}

\item{x_lim}{x-axis to be used for plot}

\item{estimator}{which estimate to be visualized}

\item{type}{The type of plot to be produced, 
"trace" will produce a trace plot of the "fixed" parameters, 
"hist" will give a histogram for the "fixed" parameters, 
and "matrix" will plot the mean and quantiles of a given sample.}

\item{...}{other plotting arguments, see plot_trace(), plot_hist(), plot_matrix()
for more information}
}
\value{
ggplot2 object
}
\description{
S3 object which produces different plots depending on the 
"type" variable
}
\examples{
data(weibull_cc, package = "BayesFBHborrow")

# Set your initial values and hyper parameters
s <- c(0, quantile(weibull_cc$tte, c(0.5, 1.0), names = FALSE))
initial_param <- list("J" = 1, 
                      "s_r" = s[2], # split points only (length J) 
                      "mu" = 0, 
                      "sigma2" = 2,
                      "lambda" = c(1, 1), 
                       "beta" = 0)

# run the MCMC sampler CHANGE THIS BEFORE FINAL CHECK
out <- BayesFBHborrow(weibull_cc, NULL, initial_param,
                iter = 10, warmup_iter = 1)

# Now let's create a variety of plots

# Staring with a histogram of beta_1 (treatment effect)
gg_hist <- plot(out, NULL, estimator = "beta_1", type = "hist",
                title = "Example histogram of beta_1")

# And an accompanied trace plot of the same parameter                 
gg_trace <- plot(out, 1:10, estimator = "beta_1", type = "trace",
                  title = "Example trace plot", xlab = "iterations",
                  ylab = "beta_1 (treatment effect)")
                  
# Lastly. visualize the smoothed baseline hazard
time_grid <- seq(0, max(s), length.out = 2000)
gg_matrix <- plot(out, time_grid, estimator = "out_slam", type = "matrix",
                  title = "Example plot of smoothed baseline hazard",
                  xlab = "time", ylab = "baseline hazard")
}
