% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ermod_exp_cov_sel.R
\name{plot_cov_sel}
\alias{plot_cov_sel}
\alias{plot_submod_performance}
\alias{plot_var_ranking}
\title{Plot variable selection performance}
\usage{
plot_submod_performance(x)

plot_var_ranking(x)
}
\arguments{
\item{x}{An object of class \code{ermod_bin_cov_sel}}
}
\value{
No return value, called for plotting side effect.
}
\description{
Plot variable selection performance
}
\details{
\code{\link[=plot_submod_performance]{plot_submod_performance()}} plots the performance of submodels
evaluated during variable selection.

\code{\link[=plot_var_ranking]{plot_var_ranking()}} plots the variable ranking
evaluated during variable selection.
}
\examples{
\dontshow{if (BayesERtools:::.if_run_ex_covsel()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(d_sim_binom_cov_hgly2)

er_binary_cov_model_kfold <- dev_ermod_bin_cov_sel(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov_candidate = c(
    "BAGE_10", "BWT_10", "BGLUC",
    "BHBA1C_5", "RACE", "VISC"
  ),
  cv_method = "kfold",
  k = 3, # Choose 3 to make the example go fast
  validate_search = TRUE,
)

plot_submod_performance(er_binary_cov_model_kfold)
plot_var_ranking(er_binary_cov_model_kfold)
}
\dontshow{\}) # examplesIf}
}
