% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussianCode.R
\name{gengaussiandata}
\alias{gengaussiandata}
\title{Generating function for Gaussian Data.}
\usage{
gengaussiandata(sample_size, mu1, mean_diff, common_sd)
}
\arguments{
\item{sample_size}{Number of subjects per arm.}

\item{mu1}{mean parameter used in call to \code{rnorm()}.
Used only in control arm.}

\item{mean_diff}{Desired Mean Difference between experimental and control groups.}

\item{common_sd}{sd parameter used in call to \code{rnorm()}.
Used in both arms.}
}
\value{
\code{gengaussiandata()} returns a data frame with columns: 'id', 'treatment',
  and 'y'.
}
\description{
\code{gengaussiandata()} function used mainly internally by
\code{gaussiantrialsimulator()} function to generate data for a two-arm
clinical trial, experimental and control groups.  Can be used to generate
random trial data.
}
\examples{
samplehistdata <- gengaussiandata(sample_size=60, mu1=25, mean_diff=0, common_sd=3)
samplehistdata
}
