% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{TidySet-class}
\alias{TidySet-class}
\alias{TidySet}
\title{A tidy class to represent a set}
\description{
A set is a group of unique elements it can be either a fuzzy set, where the
relationship is between 0 or 1 or nominal.
}
\details{
When printed if an element or a set do not have any relationship is not
shown.
They can be created from lists, matrices or data.frames. Check \code{\link[=tidySet]{tidySet()}}
constructor for more information.
}
\section{Slots}{

\describe{
\item{\code{relations}}{A data.frame with elements and the sets were they belong.}

\item{\code{elements}}{A data.frame of unique elements and related information.}

\item{\code{sets}}{A data.frame of unique sets and related information.}
}}

\examples{
x <- list("A" = letters[1:5], "B" = LETTERS[3:7])
a <- tidySet(x)
a
x <- list("A" = letters[1:5], "B" = character())
b <- tidySet(x)
b
name_sets(b)
}
\seealso{
\link{tidySet}

Other methods: 
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
