% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{changeOrg}
\alias{changeOrg}
\alias{changeOrg,Arena-method}
\title{Change organisms in the environment}
\usage{
changeOrg(object, neworgdat)

\S4method{changeOrg}{Arena}(object, neworgdat)
}
\arguments{
\item{object}{An object of class Arena.}

\item{neworgdat}{A data frame with new information about the accumulated growth, type, phenotype, x and y position for each individual in the environment.}
}
\description{
The generic function \code{changeOrg} changes organisms in the environment.
}
\details{
The argument \code{neworgdat} contains the same information as the \code{orgdat} slot of \code{\link{Arena-class}}. The \code{orgdat} slot of an \code{Arena} object can be used to create \code{neworgdat}.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,bac,amount=10) #add 10 organisms
neworgdat <- arena@orgdat #get the current orgdat
neworgdat <- neworgdat[-1,] #remove the first individual
changeOrg(arena,neworgdat)
}
\seealso{
\code{\link{Arena-class}} and \code{\link{addOrg}}
}

