#include <R.h>
#include <Rinternals.h>
#include <stdlib.h> // for NULL
#include <R_ext/Rdynload.h>

/* FIXME: 
   Check these declarations against the C/Fortran source code.
*/

/* --------------------------- */
/* .Fortran calls */
/* --------------------------- */
extern void F77_NAME(linkr)(int * link, double * a, double * ylim, int * n, int * ilk, double * y, int * lk, double * gy, int * dl, double * dlink);

/* Simulating time series */
extern void F77_NAME(simbarcr)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * r, double * theta, double * u0, int * map, int * link, double * ah, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta,  double * error, int * escale, double * Ts, int * ns, int * seed, int * rngtype, int * rev);
extern void F77_NAME(simbarfimar)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * q, double * theta, double * d, int * linkg, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta, double * error, int * escale, int * ns, int * seed, int * rngtype, int * inf, int * rev);
extern void F77_NAME(simkarfimar)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * q, double * theta, double * d, int * linkg, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta, double * error, int * escale, int * ns, int * seed, int * rngtype, int * inf, int * rev);
extern void F77_NAME(simgarfimar)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * q, double * theta, double * d, int * linkg, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta, double * error, int * escale, int * ns, int * seed, int * rngtype, int * inf, int * rev);
extern void F77_NAME(simuwarfimar)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * q, double * theta, double * d, int * linkg, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta, double * error, int * escale, int * ns, int * seed, int * rngtype, int * inf, int * rev);

/* Extracting components */
extern void F77_NAME(barcr)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, double * Ts, int * nnew, double * xnew, double * ynew, double * Tnew, int * link, double * ah, int * map, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * r, int * fixt, int * flagst, double * thetaT, int * fixnu, double * nu, int * fixu0, double * u0, int * llk, double * sll, int * sco, double * U, int * info, double * K);
extern void F77_NAME(barfimar)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar,  int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, int * llk, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h);
extern void F77_NAME(karfimar)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar,  int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, int * llk, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h);
extern void F77_NAME(garfimar)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar,  int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, int * llk, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h);
extern void F77_NAME(uwarfimar)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar,  int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, int * llk, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h);

/* Fitting parameters */
extern void F77_NAME(optimnelderbarcr)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, double * Ts, int * nnew, double * xnew, double * ynew, double * Tnew, int * link, double * ah, int * map, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi,  int * xregar, int * r, int * fixt, int * flagst, double * thetaT, int * fixnu, double * nu, int * fixu0, double * u0, double * sll, int * sco, double * U, int * info, double * K, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbbarcr)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, double * Ts, int * nnew, double * xnew, double * ynew, double * Tnew, int * link, double * ah, int * map, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi,  int * xregar, int * r, int * fixt, int * flagst, double * thetaT, int * fixnu, double * nu,  int * fixu0, double * u0, double * sll, double * U, int * info, double * K, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv); 
extern void F77_NAME(optimnelderbarfimar)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy,double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbbarfimar)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimnelderkarfimar)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy,double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbkarfimar)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimneldergarfimar)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy,double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbgarfimar)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimnelderuwarfimar)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy,double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbuwarfimar)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv);

/* Prediction */
extern void F77_NAME(predictbarcr)(int * n, double * y, double * gy, int * nreg, double * xreg, int * escale, double * error, double * Ts, int * nnew, double * xnew, double * ynew, double * Tnew, int * link, double * ah, int * map, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * fvbeta, int * p, int * fixar, int * flagsar, double * fvar, int * xregar, int * r, int * fixt, int * flagst, double * fvT, int * fixnu, double * nu, int * fixu0, double * u0);
extern void F77_NAME(btsrpredictr)(int * n, double * y, double * ylower, double * yupper, double * gy, int * nreg, double * xreg, int * escale, double * error, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * fvbeta, int * p, int * fixar, int * flagsar, double * fvar, int * xregar, int * q, int * fixma, int * flagsma, double * fvma, int * fixd, double * d, int * fixnu, double * nu, int * inf);
/* --------------------------- */
/* end of .Fortran calls */
/* --------------------------- */ 

static const R_FortranMethodDef FortranEntries[] = {
    {"linkr",                (DL_FUNC) &F77_NAME(linkr),                10},
		{"simbarcr",             (DL_FUNC) &F77_NAME(simbarcr),             28},
		{"simbarfimar",          (DL_FUNC) &F77_NAME(simbarfimar),          26},
		{"simkarfimar",          (DL_FUNC) &F77_NAME(simkarfimar),          26},
		{"simgarfimar",          (DL_FUNC) &F77_NAME(simgarfimar),          26},
		{"simuwarfimar",         (DL_FUNC) &F77_NAME(simuwarfimar),         26},
		{"barcr",                (DL_FUNC) &F77_NAME(barcr),                45},
		{"barfimar",             (DL_FUNC) &F77_NAME(barfimar),             48},
		{"karfimar",             (DL_FUNC) &F77_NAME(karfimar),             48},
		{"garfimar",             (DL_FUNC) &F77_NAME(garfimar),             48},
		{"uwarfimar",            (DL_FUNC) &F77_NAME(uwarfimar),            48},
		{"optimnelderbarcr",     (DL_FUNC) &F77_NAME(optimnelderbarcr),     52},
		{"optimlbfgsbbarcr",     (DL_FUNC) &F77_NAME(optimlbfgsbbarcr),     52},    
		{"optimnelderbarfimar",  (DL_FUNC) &F77_NAME(optimnelderbarfimar),  55},
    {"optimlbfgsbbarfimar",  (DL_FUNC) &F77_NAME(optimlbfgsbbarfimar),  55},
		{"optimnelderkarfimar",  (DL_FUNC) &F77_NAME(optimnelderkarfimar),  55},
    {"optimlbfgsbkarfimar",  (DL_FUNC) &F77_NAME(optimlbfgsbkarfimar),  55},
    {"optimneldergarfimar",  (DL_FUNC) &F77_NAME(optimneldergarfimar),  55},
    {"optimlbfgsbgarfimar",  (DL_FUNC) &F77_NAME(optimlbfgsbgarfimar),  55},
    {"optimnelderuwarfimar", (DL_FUNC) &F77_NAME(optimnelderuwarfimar), 55},
    {"optimlbfgsbuwarfimar", (DL_FUNC) &F77_NAME(optimlbfgsbuwarfimar), 55},
    {"predictbarcr",         (DL_FUNC) &F77_NAME(predictbarcr),         35},
    {"btsrpredictr",         (DL_FUNC) &F77_NAME(btsrpredictr),         34},    
    {NULL, NULL, 0}
};

void R_init_BTSR(DllInfo *dll)
{
    R_registerRoutines(dll, NULL, NULL, FortranEntries, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
