% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_func.R
\name{TimetrendCurve}
\alias{TimetrendCurve}
\title{Time-trend curve over the study time domain for counties in the US}
\usage{
TimetrendCurve(bstfit,cname,vn=5,smooth.mode=TRUE,
                     cex.title=18, cex.lab=18, cex.legend=18)
}
\arguments{
\item{bstfit}{fitted object from BSTP, BSTNB or BSTZINB}

\item{cname}{character vector of county names to use}

\item{vn}{positive integer, number of sample counties to use}

\item{smooth.mode}{logical, should splines be fitted to make it smooth}

\item{cex.title}{Positive number to control the size of the text of the main title. Defaults to 18.}

\item{cex.lab}{Positive number to control the size of the text in the axes labels. Defaults to 18.}

\item{cex.legend}{Positive number to control the size of the text in the legend. Defaults to 18.}
}
\value{
time-trend curves
}
\description{
Produce a time-trend curve over the study time domain for counties in the US
}
\examples{
data(simdat)
y <- simdat$y
X <- cbind(simdat$V1,simdat$x)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))
\donttest{
res3 <- BSTZINB(y, X, A, LinearT=TRUE, nchain=3, niter=100, nburn=20, nthin=1)
TimetrendCurve(res3,cname=countyname,vn=5,smooth.mode=TRUE,cex.title=18, cex.lab=12, cex.legend=12)
}

}
