% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Faithful}
\alias{Faithful}
\title{Waiting times between successive eruptions of the Old Faithful geyser}
\format{A data frame/tibble with 299 observations on two variables
\describe{ 
\item{time}{a numeric vector} 
\item{eruption}{a factor with levels \code{1} and \code{2}} 
}}
\source{
A. Azzalini and A. Bowman, "A Look at Some Data on the Old Faithful Geyser,"
\emph{Journal of the Royal Statistical Society}, Series C, \emph{39} (1990), 357-366.
}
\usage{
Faithful
}
\description{
Data for Exercise 5.12 and 5.111
}
\examples{

t.test(time ~ eruption, data = Faithful)
hist(Faithful$time, xlab = "wait time", main = "", freq = FALSE)
lines(density(Faithful$time))

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Faithful, aes(x = time, y = ..density..)) + 
           geom_histogram(binwidth = 5, fill = "pink", col = "black") + 
           geom_density() + 
           theme_bw() + 
           labs(x = "wait time")
}
}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
