% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Commute}
\alias{Commute}
\title{Commuting times for selected cities in 1980 and 1990}
\format{A data frame/tibble with 39 observations on three variables
\describe{ 
\item{city}{a factor with levels \code{Atlanta},
\code{Baltimore}, \code{Boston}, \code{Buffalo}, \code{Charlotte},
\code{Chicago}, \code{Cincinnati}, \code{Cleveland}, \code{Columbus},
\code{Dallas}, \code{Denver}, \code{Detroit}, \code{Hartford}, \code{Houston},
\code{Indianapolis}, \code{Kansas City}, \code{Los Angeles}, \code{Miami},
\code{Milwaukee}, \code{Minneapolis}, \code{New Orleans}, \code{New York},
\code{Norfolk}, \code{Orlando}, \code{Philadelphia}, \code{Phoenix},
\code{Pittsburgh}, \code{Portland}, \code{Providence}, \code{Rochester},
\code{Sacramento}, \code{Salt Lake City}, \code{San Antonio}, \code{San Diego},
\code{San Francisco}, \code{Seattle}, \code{St. Louis}, \code{Tampa}, and
\code{Washington}}
\item{year}{year}
\item{time}{commute times}
}}
\source{
Federal Highway Administration.
}
\usage{
Commute
}
\description{
Data for Exercises 1.13, and 7.85
}
\examples{

stripplot(year ~ time, data = Commute, jitter = TRUE) 
dotplot(year ~ time, data = Commute)
bwplot(year ~ time, data = Commute)
stripchart(time ~ year, data = Commute, method = "stack", pch = 1, 
           cex = 2, col = c("red", "blue"), 
           group.names = c("1980", "1990"), 
           main = "", xlab = "minutes")
title(main = "Commute Time") 
boxplot(time ~ year, data = Commute, names=c("1980", "1990"),
        horizontal = TRUE, las = 1)


}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
