% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_latents.R
\name{get_latents}
\alias{get_latents}
\title{Simulation of latent variables \eqn{Z} in the \emph{mixdpclust} model}
\usage{
get_latents(Y, var_type, mu_Z.ini = NULL, sigma_Z.ini = NULL,
  Z.ini = NULL)
}
\arguments{
\item{Y}{Matrix or data frame containing the observed data.}

\item{var_type}{Character vector that indicates the type of variable in each column of Y. Three possible types:
\itemize{
  \item "\strong{c}" for continuous variables.
  \item "\strong{o}" for ordinal variables (ordered categorical).
  \item "\strong{m}" for nominal variables (non-ordered categorical).
}}

\item{mu_Z.ini}{an optional vector with the expected values \eqn{\mu_Z} of the latent variables.}

\item{sigma_Z.ini}{an optional matrix with the covariance matrix \eqn{\Sigma_Z} of the latent variables.}

\item{Z.ini}{an optional matrix with initial values for the latent variables that will be simulated.}
}
\description{
Simulates values for latent variables \eqn{Z=(Z_1,...,Z_q)} according to the specification in the \emph{mixdpclust} model.
}
\details{
For each variable in the \code{Y} data frame, an associated continuos latent variable is generated.
    if \eqn{Y_j} is continuos, the corresponding \eqn{Z_j} will keep the original values of \eqn{Y_j}.
    If \eqn{Y_j} is categorical, the function will scan the unique values of \eqn{Y_j} and generate continuous latent variables accordingly.
}
\keyword{internal}
