% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeROS.R
\encoding{UTF-8}
\name{imputeROS}
\alias{imputeROS}
\title{imputing BLOQ's using regression on order statistics}
\usage{
imputeROS(inputData, LOQ, isMultiplicative = FALSE, useSeed = runif(1))
}
\arguments{
\item{inputData}{numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
 the input dataset}

\item{LOQ}{scalar limit of quantification value}

\item{isMultiplicative}{logical variable indicating whether
an additive error model (FALSE) or a multiplicative
model (TRUE) should be used}

\item{useSeed}{scalar, set a seed to make the results 
reproducible, default is runif(1), it is used to randomly 
order the first imputed column (if the first column has any BLOQ's)}
}
\value{
the imputed dataset: a numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
}
\description{
function to impute BLOQ's with regression on order statistics
(ROS) approach.
}
\examples{
# generate data from Beal model with only fixed effects
set.seed(111)
genDataFixedEffects <- simulateBealModelFixedEffects(10, 0.693,
 		1, 1, seq(0.5,3,0.5))
imputeROS(genDataFixedEffects, 0.1)
}
\author{
Vahid Nassiri, Helen Yvette Barnett
}
