% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_shapefile}
\alias{BIEN_occurrence_shapefile}
\title{Extract occurrence data for specified shapefile}
\usage{
BIEN_occurrence_shapefile(shapefile, cultivated = FALSE,
  only.new.world = TRUE, all.taxonomy = FALSE, native.status = FALSE,
  observation.type = FALSE, political.boundaries = FALSE, ...)
}
\arguments{
\item{shapefile}{An object of class SpatialPolygonsDataFrame.  Note that the polygon must be in WGS84.}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing occurrence records for the specified species.
}
\description{
BIEN_occurrence_shapefile downloads occurrence records falling within a user-specified shapefile.
}
\examples{
\dontrun{
BIEN_ranges_species("Carnegiea gigantea")#saves ranges to the current working directory
shape<-readOGR(dsn = ".",layer = "Carnegiea_gigantea")
#shapefiles should be read with readOGR(), see note.
species_occurrenes<-BIEN_occurrences_shapefile(shapefile=shape)}
}
\seealso{
Other occurrence functions: \code{\link{BIEN_occurrence_box}},
  \code{\link{BIEN_occurrence_country}},
  \code{\link{BIEN_occurrence_county}},
  \code{\link{BIEN_occurrence_family}},
  \code{\link{BIEN_occurrence_genus}},
  \code{\link{BIEN_occurrence_records_per_species}},
  \code{\link{BIEN_occurrence_species}},
  \code{\link{BIEN_occurrence_state}}
}
