% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{bfs_get_dataset}
\alias{bfs_get_dataset}
\title{Get BFS PC-Axis files as data frames}
\usage{
bfs_get_dataset(url_px)
}
\arguments{
\item{url_px}{The url link to download the PC-Axis file.}
}
\description{
Returns a data frame/tibble from a given BFS PC-Axis file. The
column names are always rendered in German and are renamed 
using the \code{\link[janitor]{clean_names}} function of the
janitor package.
}
\examples{
\donttest{df_en <- bfs_get_metadata(language = "en")}
\donttest{bfs_search("education", df_en)}
\donttest{bfs_get_dataset(df_en$url_px[3])}

}
