#' A Package to Extract Genotypes from a PLINK .bed File.
#'
#' The `BEDMatrix` package provides a matrix-like wrapper around
#' [.bed](https://www.cog-genomics.org/plink2/formats#bed) files, one of the
#' genotype/phenotype file formats of
#' [PLINK](https://www.cog-genomics.org/plink2), the whole genome association
#' analysis toolset. [BEDMatrix-class] objects are created by simply providing
#' the path to a .bed file and once created, they behave similarly to regular
#' matrices with the advantage that genotypes are retrieved on demand without
#' loading the entire file into memory. This allows handling of very large
#' files with limited use of memory.
#'
#' @section .bed Files:
#' [.bed](https://www.cog-genomics.org/plink2/formats#bed) files (sometimes
#' referred to as binary .ped files) are binary representations of genotype
#' calls at biallelic variants. This very compact file format (2 bits per
#' genotype call) is used and generated by
#' [PLINK](https://www.cog-genomics.org/plink2/). .bed files should not be
#' confused with the [UCSC Genome Browser's BED format](https://genome.ucsc.edu/FAQ/FAQformat.html#format1),
#' which is totally different.
#'
#' A .bed file can be created from a
#' [.ped](https://www.cog-genomics.org/plink2/formats#ped) file with
#' [PLINK](https://www.cog-genomics.org/plink2) using `plink --file myfile
#' --make-bed`.
#'
#' @seealso [BEDMatrix-class] to learn more about the `BEDMatrix` class.
#' @docType package
#' @name BEDMatrix-package
#' @aliases BEDMatrix-package
#' @import methods Rcpp
#' @useDynLib BEDMatrix, .registration = TRUE
NULL
