% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causaleffect.R
\name{causaleffect}
\alias{causaleffect}
\title{Compute causal effects between variables}
\usage{
causaleffect(targets, response, L, D)
}
\arguments{
\item{targets}{numerical vector with labels of target nodes}

\item{response}{numerical label of response variable}

\item{L}{\eqn{(q,q)} matrix of regression-coefficient parameters}

\item{D}{\eqn{(q,q)} diagonal matrix of conditional-variance parameters}
}
\value{
The joint total causal effect, represented as a vector of same length of \code{targets}
}
\description{
This function computes the total joint causal effect on variable \code{response} consequent to an intervention on variables \code{targets}
for a given a DAG structure and parameters \code{(D,L)}
}
\details{
We assume that the joint distribution of random variables \eqn{X_1, \dots, X_q} is zero-mean Gaussian with covariance matrix Markov w.r.t. a Directed Acyclic Graph (DAG).
In addition, the allied Structural Equation Model (SEM) representation of a Gaussian DAG-model allows to express the covariance matrix as a function of the (Cholesky) parameters \code{(D,L)},
collecting the conditional variances and regression coefficients of the SEM.

The total causal effect on a given variable of interest (\code{response}) consequent to a joint intervention on a set of variables (\code{targets})
is defined according to Pearl's do-calculus theory and under the Gaussian assumption can be expressed as a function of parameters \code{(D,L)}.
}
\examples{
# Randomly generate a DAG and the DAG-parameters
q = 8
w = 0.2
set.seed(123)
DAG = rDAG(q = q, w = w)
outDL = rDAGWishart(n = 1, DAG = DAG, a = q, U = diag(1, q))
L = outDL$L; D = outDL$D
# Total causal effect on node 1 of an intervention on {5,6}
causaleffect(targets = c(6,7), response = 1, L = L, D = D)
# Total causal effect on node 1 of an intervention on {5,7}
causaleffect(targets = c(5,7), response = 1, L = L, D = D)

}
\references{
J. Pearl (2000). \emph{Causality: Models, Reasoning, and Inference}. Cambridge University Press, Cambridge.

F. Castelletti and A. Mascaro (2021). Structural learning and estimation of joint causal effects among network-dependent variables. \emph{Statistical Methods and Applications}, Advance publication.

P. Nandy, M.H. Maathuis and T. Richardson (2017). Estimating the effect of joint interventions from observational data in sparse high-dimensional settings. \emph{Annals of Statistics} 45(2), 647-674.
}
\author{
Federico Castelletti and Alessandro Mascaro
}
