\name{partition.ch}
\alias{partition.ch}
\title{
Partition of partial capture histories according to equivalence classes of numerical quantification corresponding to supplied intervals
}
\description{
All the possible partial capture histories observable during a capture-recapture experiment with \eqn{t} sampling occasions can be partitioned according to numerical values corresponding to some meaningful covariate (quantification of binary sequences corresponding to partial capture histories). Each subset of the partition corresponds to all partial capture histories which returns 
numerical values of the quantification within one of the intervals represented by two consecutive values in the optional argument vector \code{breaks}.
}
\usage{
partition.ch(quantify.ch.fun, t, breaks, include.lowest = T, 
   type = c("list", "index"), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{quantify.ch.fun}{
a function which returns a numerical value for each possible partial capture history
}
  \item{t}{
an integer. \code{t} is number of trapping occasions
}
  \item{breaks}{
a vector of numerical values which are used as bounds for the interval of numerical values corresponding to partial capture histories that belongs to the same partition
}
  \item{include.lowest}{
a logical, indicating if an x[i] equal to the lowest (or highest, when  right = FALSE) breaks value should be included
}
  \item{type}{
a character string. It can be either  \code{"list"} or  \code{"index"}. See examples.
}
  \item{\dots}{
additional arguments to be passed to \code{quantify.ch.fun}
}
}
\details{
It is useful in conjunction with \code{LBRecap.custom.part}. See examples.
}
\value{
If the argument \code{type="list"} a list is returned. If \code{type="index"} a numerical index corresponding to the numeric integer equivalent of the consecutive interval
according to the convention used in objects of class \code{factor}
}
\author{
Danilo Alunni Fegatelli and Luca Tardella
}


\seealso{
\code{\link{LBRecap.custom.part}}, \code{\link{BBRecap.custom.part}}
}
\examples{

data(mouse)
head(mouse)
t=ncol(mouse)

Mc1.partition=partition.ch(quantify.ch.fun=quant.binary,t=t,breaks=c(0,0.5,1))
Mc1.partition

mod.Mc1.cust=BBRecap.custom.part(mouse,partition=Mc1.partition)
mod.Mc1.cust

mod.Mc1.easy=BBRecap(mouse,mod="Mc",markov.ord=1,output="complete")

mod.Mc1.easy$N.hat.RMSE
mod.Mc1.easy$HPD.N
mod.Mc1.easy$log.marginal.likelihood

# the two functions give the same results!


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
