% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{linnean}
\alias{linnean}
\title{Create Linnean tree.}
\usage{
linnean(taxa, distance = NULL)
}
\arguments{
\item{taxa}{A taxonomic matrix with columns ordered according to linnean hierarchy starting with the highest.}

\item{distance}{A vector with distances between levels starting with the highest. If not provided distances will be evenly distributed from 1 to 0.}
}
\value{
An hclust with all species.
}
\description{
Creates a Linnean tree from taxonomic hierarchy.
}
\examples{
family <- c("Nemesiidae", "Nemesiidae", "Zodariidae", "Zodariidae")
genus <- c("Iberesia", "Nemesia", "Zodarion", "Zodarion")
species <- c("Imachadoi", "Nungoliant", "Zatlanticum", "Zlusitanicum")
taxa <- cbind(family, genus, species)
par(mfrow = c(1, 2))
plot(linnean(taxa))
plot(linnean(taxa, c(2, 0.5, 0.3)))
}
