% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAMBI.R
\name{is.angmcmc}
\alias{is.angmcmc}
\alias{angmcmc}
\title{Angular MCMC (\code{angmcmc}) Object}
\usage{
is.angmcmc(object)

angmcmc(...)
}
\arguments{
\item{object}{any R object}

\item{...}{arguments required to make an angmcmc object. See details}
}
\value{
logical. Is the input an angmcmc object?
}
\description{
Checking for and creating an angmcmc object
}
\details{
\code{angmcmc} objects are classified lists that are created when any of the five mixture model fitting
functions, viz., \code{fit_vmmix}, \code{fit_wnormmix}, \code{fit_vmsinmix}, \code{fit_vmcosmix} and
\code{fit_wnorm2mix} is used. An \code{angmcmc} object contains a number of elements, including the dataset, the
model being fitted on the dataset and dimension of the model (univariate or bivariate), the tuning parameters
used, MCMC samples for the mixture model parameters, the (hidden) component or cluster indicators for  data
points in each iteration and the (iteration-wise) log likelihood and log posterior density values (both calculated
upto some normalizing constants). When printed, an angmcmc object returns a brief summary of the function
arguments used to produce the object and the average acceptance rate of the proposals (in HMC and RWMH) used
over iterations. An \code{angmcmc} object can be used as an argument for the diagnostic and post-processing
functions available in \code{BAMBI} for making further inferences.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
is.angmcmc(fit.vmsin.20)
}
