% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_model_plots.R
\name{surface_model}
\alias{surface_model}
\title{Densitysurface for bivariate angular mixture model densities}
\usage{
surface_model(model = "vmsin", kappa1, kappa2, kappa3, mu1, mu2,
  pmix = rep(1/length(kappa1), length(kappa1)), xpoints = seq(0, 2 * pi,
  length.out = 50), ypoints = seq(0, 2 * pi, length.out = 50), xlab = "x",
  ylab = "y", zlab = "Density", main, theta = 30, phi = 30,
  shade = 0.01, expand = 0.5, ...)
}
\arguments{
\item{model}{bivariate angular model whose mixture is of interest. Must be one of
"vmsin", "vmcos" and "wnorm2".}

\item{kappa1, kappa2, kappa3, mu1, mu2, pmix}{model parameters and mixing
proportions. See the respective mixture model densities (\link{dvmsinmix}, \link{dvmcosmix},
\link{dwnorm2mix}) for more details.}

\item{xpoints}{Points on the first (x-) coordinate where the density is to be evaluated.
Default to seq(0, 2*pi, length.out=100).}

\item{ypoints}{Points on the first (x-) coordinate where the density is to be evaluated.
Default to seq(0, 2*pi, length.out=100).}

\item{xlab, ylab, zlab, main, theta, phi, shade, expand}{graphical parameters passed to \link{persp}}

\item{...}{additional model specific argment}
}
\description{
Densitysurface for bivariate angular mixture model densities
}
