% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_vm_resource.R
\docType{class}
\name{az_vm_resource}
\alias{az_vm_resource}
\title{Virtual machine resource class}
\format{An R6 object of class \code{az_vm_resource}, inheriting from \code{AzureRMR::az_resource}.}
\usage{
az_vm_resource
}
\description{
Class representing a virtual machine resource. In general, the methods in this class should not be called directly, nor should objects be directly instantiated from it. Use the \code{az_vm_template} class for interacting with VMs instead.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new VM object.
\item \code{start(wait=TRUE)}: Start the VM. By default, wait until the startup process is complete.
\item \code{stop(deallocate=TRUE, wait=FALSE)}: Stop the VM. By default, deallocate it as well.
\item \code{restart(wait=TRUE)}: Restart the VM.
\item \code{run_deployed_command(command, parameters, script)}: Run a PowerShell command on the VM.
\item \code{run_script(script, parameters)}: Run a script on the VM. For a Linux VM, this will be a shell script; for a Windows VM, a PowerShell script. Pass the script as a character vector.
\item \code{sync_vm_status()}: Update the VM status fields in this object with information from the host.
\item \code{resize(size, deallocate=FALSE, wait=FALSE)}: Resize the VM. Optionally deallocate it first (may sometimes be necessary).
}
}

\seealso{
\link[AzureRMR:az_resource]{AzureRMR::az_resource},
\href{https://docs.microsoft.com/en-us/rest/api/compute/virtualmachines}{VM API reference}
}
\keyword{datasets}
