% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{download_from_url}
\alias{download_from_url}
\alias{upload_to_url}
\title{Generic upload and download}
\usage{
download_from_url(src, dest, key = NULL, sas = NULL, ...,
  overwrite = FALSE)

upload_to_url(src, dest, key = NULL, sas = NULL, ...)
}
\arguments{
\item{src, dest}{The source and destination files/URLs. Paths are allowed.}

\item{key, sas}{Authentication arguments: an access key or a shared access signature (SAS). If a key is is provided, the SAS is not used. If neither an access key nor a SAS are provided, only public (anonymous) access to the share is possible.}

\item{...}{Further arguments to pass to lower-level functions.}

\item{overwrite}{For downloading, whether to overwrite any destination files that exist.}
}
\description{
Generic upload and download
}
\details{
These functions allow you to transfer files to and from a storage account, given the URL of the destination (for uploading) or source (for downloading). They dispatch to \link{upload_azure_file}/\link{download_azure_file} for a file storage URL and \link{upload_blob}/\link{download_blob} for a blob storage URL respectively.

You can provide a SAS either as part of the URL itself, or in the \code{sas} argument.
}
\examples{
\dontrun{

# authenticated download with an access key
download_from_url("https://mystorage.blob.core.windows.net/mycontainer/bigfile.zip",
                  "~/bigfile.zip",
                  key="access_key")

}
}
\seealso{
\link{download_azure_file}, \link{download_blob}, \link{az_storage}
}
