% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adls_client_funcs.R
\name{list_adls_files}
\alias{list_adls_files}
\alias{upload_adls_file}
\alias{download_adls_file}
\alias{delete_adls_file}
\alias{create_adls_dir}
\alias{delete_adls_dir}
\title{Operations on an Azure Data Lake Storage Gen2 filesystem}
\usage{
list_adls_files(filesystem, dir = "/", info = c("all", "name"),
  recursive = FALSE)

upload_adls_file(filesystem, src, dest, blocksize = 2^24, lease = NULL)

download_adls_file(filesystem, src, dest, overwrite = FALSE)

delete_adls_file(filesystem, file, confirm = TRUE)

create_adls_dir(filesystem, dir)

delete_adls_dir(filesystem, dir, recursive = FALSE, confirm = TRUE)
}
\arguments{
\item{filesystem}{An ADLSgen2 filesystem object.}

\item{dir, file}{A string naming a directory or file respectively.}

\item{info}{Whether to return names only, or all information in a directory listing.}

\item{recursive}{For \code{list_adls_files}, and \code{delete_adls_dir}, whether the operation should recurse through subdirectories. For \code{delete_adls_dir}, this must be TRUE to delete a non-empty directory.}

\item{src, dest}{The source and destination filenames for uploading and downloading. Paths are allowed.}

\item{blocksize}{The number of bytes to upload per HTTP(S) request.}

\item{lease}{The lease for a file, if present.}

\item{overwrite}{When downloading, whether to overwrite an existing destination file.}

\item{confirm}{Whether to ask for confirmation on deleting a file or directory.}
}
\value{
For \code{list_adls_files}, if \code{info="name"}, a vector of file/directory names. If \code{info="all"}, a data frame giving the file size and whether each object is a file or directory.
}
\description{
Upload, download, or delete a file; list files in a directory; create or delete directories.
}
\examples{
\dontrun{

fs <- adls_filesystem("https://mystorage.dfs.core.windows.net/myfilesystem", key="access_key")

list_adls_files(fs, "/")

create_adls_dir(fs, "/newdir")

upload_adls_file(fs, "~/bigfile.zip", dest="/newdir/bigfile.zip")
download_adls_file(fs, "/newdir/bigfile.zip", dest="~/bigfile_downloaded.zip")

delete_adls_file(fs, "/newdir/bigfile.zip")
delete_adls_dir(fs, "/newdir")

}
}
\seealso{
\link{adls_filesystem}, \link{az_storage}
}
