% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext_tools.R
\name{call_kubectl}
\alias{call_kubectl}
\title{Call the Kubernetes commandline tool, kubectl}
\usage{
call_kubectl(cmd = "", config = NULL, ..., echo = TRUE)
}
\arguments{
\item{cmd}{The kubectl command line to execute.}

\item{config}{The pathname of the cluster config file, if required.}

\item{...}{Other arguments to pass to \link[processx:run]{processx::run}.}

\item{echo}{Whether to echo the output of the command to the console.}
}
\value{
A list with the following components:
\itemize{
\item \code{status}: The exit status of the kubectl tool. If this is \code{NA}, then the process was killed and had no exit status.
\item \code{stdout}: The standard output of the command, in a character scalar.
\item \code{stderr}: The standard error of the command, in a character scalar.
\item \code{timeout}: Whether the process was killed because of a timeout.
\item \code{cmdline}: The command line.
}

The first four components are from \code{processx::run}; AzureContainers adds the last to make it easier to construct scripts that can be run outside R.
}
\description{
Call the Kubernetes commandline tool, kubectl
}
\details{
This function calls the \code{kubectl} binary, which must be located in your search path. AzureContainers will search for the binary at package startup, and print a warning if it is not found.
}
\examples{
\dontrun{

# without any args, prints the kubectl help screen
call_kubectl()

# append "--help" to get help for a command
call_kubectl("create --help")

# deploy a service from a yaml file
call_kubectl("create -f deployment.yaml")

# get deployment and service status
call_kubectl("get deployment")
call_kubectl("get service")

}
}
\seealso{
\link[processx:run]{processx::run}, \link{call_docker}, \link{call_helm}

\link{kubernetes_cluster}

\href{https://kubernetes.io/docs/reference/kubectl/overview/}{Kubectl command line reference}
}
