% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kubernetes_cluster.R
\name{call_kubectl}
\alias{call_kubectl}
\title{Call the Kubernetes commandline tool, kubectl}
\usage{
call_kubectl(cmd = "", ...)
}
\arguments{
\item{cmd}{The kubectl command line to execute.}

\item{...}{Other arguments to pass to \link{system2}.}
}
\value{
By default, the return code from the \code{kubectl} binary. The return value will have an added attribute \code{cmdline} that contains the command line. This makes it easier to construct scripts that can be run outside R.
}
\description{
Call the Kubernetes commandline tool, kubectl
}
\details{
This function calls the \code{kubectl} binary, which must be located in your search path. AzureContainers will search for the binary at package startup, and print a warning if it is not found.
}
\examples{
\dontrun{

# without any args, prints the kubectl help screen
call_kubectl()

# append "--help" to get help for a command
call_kubectl("create --help")

# deploy a service from a yaml file
call_kubectl("create -f deployment.yaml")

# get deployment and service status
call_kubectl("get deployment")
call_kubectl("get service")

}
}
\seealso{
\link{system2}, \link{call_docker}, \link{call_helm}

\link{kubernetes_cluster}

\href{https://kubernetes.io/docs/reference/kubectl/overview/}{Kubectl command line reference}
}
