% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endomaker_dir.R
\name{endomaker_dir}
\alias{endomaker_dir}
\title{endomaker_dir}
\usage{
endomaker_dir(dir_path, param1_endo = 1.5, npovs = 50, volume = TRUE,
  alpha_vol = 50, nVoxels = 1e+05, decmesh = 20000, alpha_ext = 30,
  ncells = 50000, npovs_calse = 50, param1_calse = 3,
  param1_ast = 1.3, decendo = 20000, scalendo = 0.5,
  alpha_end = 100, mpovdist = 10, plotall = FALSE,
  colmesh = "orange", save = FALSE, outpath = tempdir(),
  num.cores = NULL)
}
\arguments{
\item{dir_path}{character: path of the folder where the skull meshes are stored}

\item{param1_endo}{numeric vector: parameter for spherical flipping}

\item{npovs}{numeric: number of Points of View used in the endocast construction}

\item{volume}{logical: if TRUE the volume of the endocast (ECV) is estimated}

\item{alpha_vol}{numeric: alpha shape for volume calculation}

\item{nVoxels}{numeric: number of voxels for estimation endocranial volume}

\item{decmesh}{numeric: decmesh}

\item{alpha_ext}{numeric: alpha shape for construction external cranial mesh}

\item{ncells}{numeric: approximative number of cell for 3D grid construction}

\item{npovs_calse}{numeric: number of Points of View for construction of skull shell}

\item{param1_calse}{numeric: parameter for calse (construction shell)}

\item{param1_ast}{numeric: parameter for ast3d (construction row endocast)}

\item{decendo}{numeric: desired number of triangles (row endocast)}

\item{scalendo}{numeric: scale factor row endocast (for definition of POVs)}

\item{alpha_end}{numeric: alpha shape value for concave hull (row endocast)}

\item{mpovdist}{numeric vector: mean value between POVs and mesh}

\item{plotall}{logical: if TRUE the endocasts are plotted}

\item{colmesh}{character: color of the mesh to be plotted}

\item{save}{logical: if TRUE the mesh of the endocast is saved}

\item{outpath}{character: path where save the endocast}

\item{num.cores}{numeric: number of cores to be used in parallel elaboration}
}
\value{
endocasts mesh3d: list of meshes of the extracted endocasts

volumes numeric: volumes of the endocasts expressed in cc
}
\description{
Build library of endocasts from skull 3D meshes
}
\author{
Antonio Profico, Costantino Buzi, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
}
