% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iff.0.r
\name{write.iff}
\alias{write.iff}
\title{Write Interchange File Format (IFF)}
\usage{
write.iff(x, file)
}
\arguments{
\item{x}{An \code{\link{IFFChunk}} object that needs to be written to a file.}

\item{file}{A filename for the IFF file to which the \code{\link{IFFChunk}} needs
to be saved, or a connection to which the data should be written.}
}
\value{
Returns either \code{NULL} or an \code{integer} status invisibly as passed
by the \code{\link[base]{close}} statement used to close the file connection.
}
\description{
Write an \code{\link{IFFChunk}} object conform the Interchange File Format (IFF).
}
\details{
Writes an \code{\link{IFFChunk}} object (including all nested chunks) to the
specified file. Only the structure of the object needs to be valid, however,
a correctly structured file does not necessarily result in an interpretable file
(see examples).
}
\examples{
\dontrun{
## read an IFF file as an IFFChunk object:
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## This will write the IFF file (in this case a bitmap image)
## to the temp directory:
write.iff(example.iff, file.path(tempdir(), "image.iff"))

}
}
\references{
\url{https://en.wikipedia.org/wiki/Interchange_File_Format}
}
\seealso{
Other io.operations: \code{\link{read.AmigaIcon}},
  \code{\link{read.SysConfig}}, \code{\link{read.iff}},
  \code{\link{write.AmigaIcon}},
  \code{\link{write.SysConfig}}

Other iff.operations: \code{\link{IFFChunk-class}},
  \code{\link{WaveToIFF}}, \code{\link{as.raster}},
  \code{\link{as.raw}}, \code{\link{getIFFChunk}},
  \code{\link{interpretIFFChunk}},
  \code{\link{rasterToIFF}}, \code{\link{rawToIFFChunk}},
  \code{\link{read.iff}}
}
\author{
Pepijn de Vries
}
