% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrids.R
\name{calcGCA}
\alias{calcGCA}
\title{Calculate GCA}
\usage{
calcGCA(pop, use = "pheno")
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}} or 
\code{\link{HybridPop-class}}}

\item{use}{true genetic value "gv" or phenotypes "pheno" (default)}
}
\description{
Calculate general combining ability of test crosses. Intended for 
output from hybridCross using the "testcross" option, but will work 
for any population.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10, inbred=TRUE)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Make crosses for full diallele
pop2 = hybridCross(pop, pop, simParam=SP)
GCA = calcGCA(pop2, use="gv")

}
