% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_setTrackPed}
\alias{SimParam_setTrackPed}
\title{Set pedigree tracking}
\arguments{
\item{isTrackPed}{should pedigree tracking be on.}

\item{force}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\description{
Sets pedigree tracking for the simulation. 
By default pedigree tracking is turned off. When turned on, 
the pedigree of all individuals created will be tracked, 
except those created by \code{\link{hybridCross}}. Turning 
off pedigree tracking will turn off recombination tracking 
if it is turned on.
}
\section{Usage}{
 SP$setTrackPed(isTrackPed, force = FALSE)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setTrackPed(TRUE)

}
