% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PurpleAirQC_hourly_AB_03.R
\name{PurpleAirQC_hourly_AB_03}
\alias{PurpleAirQC_hourly_AB_03}
\title{Apply hourly aggregation QC using "AB_O4" algorithm}
\usage{
PurpleAirQC_hourly_AB_03(pat = NULL, min_count = 20, returnAllColumns = FALSE)
}
\arguments{
\item{pat}{A PurpleAir timeseries object.}

\item{min_count}{Aggregation bins with fewer than \code{min_count} measurements
will be marked as NA.}

\item{returnAllColumns}{Logical specifying whether to return all columns
of statistical data generated for QC algorithm or just the final \code{pm25}
result.}
}
\value{
Data frame with columns \code{datetime} and \code{pm25}.
}
\description{
Creates a \emph{pm25} timeseries by averaging aggregated data
from the A and B channels and applying the following QC logic:

\enumerate{
\item{Create pm25 by averaging the A and B channel aggregation means}
\item{Invalidate data where:  (min_count < 20)}
\item{Invalidate data where:  (A/B hourly difference > 5 AND A/B hourly percent difference > 70\%)}
\item{Invalidate data where:  (A/B hourly data recovery < 90\%)}
}
}
\note{
Purple Air II sensors reporting after the June, 2019 firmware
upgrade report data every 2 minutes or 30 measurements per hour. The default
setting of \code{min_count = 20} is equivalent to a required data recovery
rate of 67\%.
}
\examples{
\donttest{
library(AirSensor)

df_00 <- 
  example_pat_failure_A \%>\%
  pat_qc() \%>\%
  PurpleAirQC_hourly_AB_00()
  
df_01 <- 
  example_pat_failure_A \%>\%
  pat_qc() \%>\%
  PurpleAirQC_hourly_AB_01()
  
df_03 <- 
  example_pat_failure_A \%>\%
  pat_qc() \%>\%
  PurpleAirQC_hourly_AB_03()
  
layout(matrix(seq(2)))

plot(df_00, pch = 16, cex = 0.8, col = "red")
points(df_01, pch = 16, cex = 0.8, col = "black")
title("example_pat_failure_A -- PurpleAirQC_hourly_AB_01")

plot(df_00, pch = 16, cex = 0.8, col = "red")
points(df_03, pch = 16, cex = 0.8, col = "black")
title("example_pat_failure_A -- PurpleAirQC_hourly_AB_03")

layout(1)
}
}
