% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_dailySoHIndexPlot.R
\name{pat_dailySoHIndexPlot}
\alias{pat_dailySoHIndexPlot}
\title{Daily State of Health metric plot}
\usage{
pat_dailySoHIndexPlot(
  pat = NULL,
  minPctReporting = 50,
  breaks = c(0, 0.2, 0.8, 1),
  SoHIndex_FUN = pat_dailySoHIndex_00
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{minPctReporting}{Percent reporting threshold for A and B channels.}

\item{breaks}{Breaks used to convert index values into index bins.}

\item{SoHIndex_FUN}{Function used to create \code{SoHIndex} tibble. (Not quoted.)}
}
\description{
This function plots a subset of the most useful State of Health 
metrics calculated with \code{SoHIndex_FUN}.

Both \code{minPctReporting} and \code{breaks} are passed to 
\code{SoHIndex_FUN}.
}
\examples{
\donttest{
library(AirSensor)

gg_A <- pat_dailySoHIndexPlot(example_pat_failure_A)
gg_B <- pat_dailySoHIndexPlot(example_pat_failure_B)

multi_ggplot(gg_A, gg_B)
}
}
\seealso{
\link{pat_dailySoHIndex_00}
}
