% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_trimDate.R
\name{pat_trimDate}
\alias{pat_trimDate}
\title{Trim a PurpleAir Timeseries object to full days}
\usage{
pat_trimDate(pat = NULL)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}
}
\value{
A subset of the given \emph{pat} object.
}
\description{
Trims the date range of a \emph{pat} object to local time date
boundaries which are \emph{within} the range of data. This has the effect
of removing partial-day data records and is useful when calculating
full-day statistics.
}
\examples{
library(AirSensor)

UTC_week <- pat_filterDate(
  example_pat, 
  startdate = 20180808, 
  enddate = 20180815,
  timezone = "UTC"
)

pat_multiPlot(UTC_week)

local_week <- pat_trimDate(UTC_week)
pat_multiPlot(local_week)

}
