% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_dygraph.R
\name{monitor_dygraph}
\alias{monitor_dygraph}
\title{Create Interactive Time Series Plot}
\usage{
monitor_dygraph(
  monitor,
  title = "title",
  ylab = "PM2.5 Concentration",
  rollPeriod = 1,
  showLegend = TRUE
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{title}{Title text.}

\item{ylab}{Title for the y axis}

\item{rollPeriod}{Rolling mean to be applied to the data.}

\item{showLegend}{Logical to toggle display of the legend.}
}
\value{
Initiates the interactive dygraph plot in RStudio's 'Viewer' tab.
}
\description{
This function creates interactive graphs that will be displayed
in RStudio's 'Viewer' tab.
}
\examples{
\dontrun{
library(AirMonitor)

# Multiple monitors
Camp_Fire \%>\%
  monitor_filter(countyName == "Alameda") \%>\%
  monitor_dygraph()
}
}
