% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowrat.R
\name{flowrat}
\alias{flowrat}
\title{Calculation of required spray nozzle flow}
\usage{
flowrat(Q, q, V, W = 50)
}
\arguments{
\item{Q}{Application rate (L/ha)}

\item{q}{Nozzle flow (L/min)}

\item{V}{Sprayer speed (km/h)}

\item{W}{Spacing between spray nozzles (cm)}
}
\value{
Returns values for flow, application rate, sprayer speed, spacing between spray tips
}
\description{
This is a function to determine the required flow rate of a spray nozzle
}
\details{
Application rate (L/ha):
\deqn{Q=\frac{60000*q}{V*W}}
Nozzle flow (L/min):
\deqn{q=\frac{Q*(V*W)}{60000}}
Sprayer speed (km/h):
\deqn{V=\frac{\frac{60000*q}{Q}}{W}}
Spacing between spray nozzles (m):
\deqn{W=\frac{\frac{60000*q}{Q}}{V}}
}
\note{
60000 Units conversion factor
}
\examples{
flowrat(Q = 190,q = NA,V = 10,W = 50)
}
\references{
ANDEF Associacao Nacional de Defesa Vegetal. Manual de tecnologia de aplicacao de produtos fitossanitarios. Campinas: Linea Creativa, 2004. 50p.

BOLLER, W.; RAETANO, C. G. Bicos e pontas de pulverizacao de energia hidraulica, regulagens e calibracao de pulverizadores de barras. In: ANTUNIASSI, U. R.; BOLLER, W. (Organizadores). Tecnologia de aplicacao para culturas anuais. Passo Fundo: Aldeia Norte; Botucatu: FEPAF, 2011. p.51-82.

SPRAYING SYSTEMS CO. Catalogo 51A-PT - Produtos de pulverizacao para agricultura. Wheaton: Spraying Systems Co., 2014. 160p.
}
\seealso{
\link{flowpres}
\link{product}
}
\author{
Rodrigo Yudi Palhaci Marubayashi, \email{marubayashi@uel.br}

Gabriel Danilo Shimizu

Otavio Jorge Grigoli Abi Saab
}
