% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thompson_analysis.R
\name{thompson}
\alias{thompson}
\title{Analysis: Thompson}
\usage{
thompson(
  trat,
  resp,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  error = "SE",
  r2 = "all",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  round = NA,
  yname.formula = "y",
  xname.formula = "x",
  comment = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is c(0.3,0.8))}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{round}{round equation}

\item{yname.formula}{Name of y in the equation}

\item{xname.formula}{Name of x in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs Thompson regression analysis.
}
\details{
The logarithmic model is defined by:
\deqn{y = \beta_1 ln(\cdot x) + \beta_2 ln(\cdot x)^2}
}
\examples{
library(AgroReg)
resp=c(10,8,6.8,6,5,4.3,4.1,4.2,4.1)
trat=seq(1,9,1)
thompson(trat,resp)
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley & Sons (p. 330).

Sadeghi, E., Haghighi Asl, A., & Movagharnejad, K. (2019). Mathematical modelling of infrared-dried kiwifruit slices under natural and forced convection. Food science & nutrition, 7(11), 3589-3606.
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
