% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_analysis.R
\name{AM}
\alias{AM}
\title{Analysis: Avhad and Marchetti}
\usage{
AM(
  trat,
  resp,
  initial = list(alpha, k, n),
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  error = "SE",
  r2 = "all",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  round = NA,
  xname.formula = "x",
  yname.formula = "y",
  comment = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{initial}{Starting estimates}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{round}{round equation}

\item{xname.formula}{Name of x in the equation}

\item{yname.formula}{Name of y in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs Avhad and Marchetti regression analysis.
}
\details{
The Avhad e Marchetti model is defined by:
\deqn{y = \alpha \times e^{kx^n}}
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
AM(time,100-WL,initial=list(alpha = 610.9129, k=-1.1810, n=0.1289 ))
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley & Sons (p. 330).

Avhad, M. R., & Marchetti, J. M. (2016). Mathematical modelling of the drying kinetics of Hass avocado seeds. Industrial Crops and Products, 91, 76-87.
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
