% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadraticplateau_analysis.R
\name{quadratic.plateau}
\alias{quadratic.plateau}
\title{Analysis: Quadratic-plateau Regression}
\usage{
quadratic.plateau(
  trat,
  resp,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  error = "SE",
  r2 = "all",
  point = "all",
  scale = "none"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs the quadratic-plateau regression analysis.
}
\details{
The linear-linear model is defined by:

First curve:
\deqn{f(x) = b0+b1*x+b2*x^2 (x<breakpoint)}

Second curve:
\deqn{f(x) = b0+b1*breakpoint+b2*breakpoint^2 (x>breakpoint)}
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
quadratic.plateau(time,WL)
}
\references{
Chiu, G. S., R. Lockhart, and R. Routledge. 2006. Bent-cable regression theory and applications. Journal of the American Statistical Association 101:542-553.

Toms, J. D., and M. L. Lesperance. 2003. Piecewise regression: a tool for identifying ecological thresholds. Ecology 84:2034-2041.
}
\seealso{
\link{linear.linear}, \link{linear.plateau}
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
