% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individuals_stats_per_minutes.R
\name{individuals_stats_per_minutes}
\alias{individuals_stats_per_minutes}
\title{individual statistics calculator per minutes}
\usage{
individuals_stats_per_minutes(df1, m)
}
\arguments{
\item{df1}{Should be a Data Frame that represents the individual statistics of the players. The parameter has to be in the format provided by the data_adjustment() function.}

\item{m}{Should be a number. This parameter has to be the number of minutes to which you want to project the statistics.}
}
\value{
Data frame with statistics by game projected to the minutes entered.
}
\description{
The function allows the calculation of the statistics per game projected to M minutes.
}
\details{
The statistical projection is made from the relationship between the number of minutes entered and the number of minutes played by the player.
}
\examples{


df1 <- data.frame("name" = c("LeBron James","Team"),"G" = c(67,0),
"GS" = c(62,0),"MP" = c(2316,0),"FG" = c(643,0), "FGA" = c(1303,0),
"Percentage FG" = c(0.493,0),"3P" = c(148,0),"3PA" = c(425,0),
"Percentage 3P" = c(0.348,0),"2P" = c(495,0),"2PA" = c(878,0),
"Percentage 2P" = c(0.564,0),"FT" = c(264,0),"FTA FG" = c(381,0),
"Percentage FT" = c(0.693,0), "ORB" = c(66,0),"DRB" = c(459,0),
"TRB" = c(525,0),"AST" = c(684,0),"STL" = c(78,0),"BLK" = c(36,0),
"TOV" = c(261,0),"PF" = c(118,0),"PTS" = c(1698,0),"+/-" = c(0,0))

m <- 48

individuals_stats_per_minutes(df1,m)



}
\author{
Fco Javier Cantero \email{fco.cantero@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
