% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{plot.CMA_per_episode}
\alias{plot.CMA_per_episode}
\alias{plot.CMA_sliding_window}
\title{Plot CMA_per_episode and CMA_sliding_window objects.}
\usage{
\method{plot}{CMA_per_episode}(
  x,
  patients.to.plot = NULL,
  duration = NA,
  align.all.patients = FALSE,
  align.first.event.at.zero = TRUE,
  show.period = c("dates", "days")[2],
  period.in.days = 90,
  show.legend = TRUE,
  legend.x = "right",
  legend.y = "bottom",
  legend.bkg.opacity = 0.5,
  legend.cex = 0.75,
  legend.cex.title = 1,
  cex = 1,
  cex.axis = 0.75,
  cex.lab = 1,
  show.cma = TRUE,
  xlab = c(dates = "Date", days = "Days"),
  ylab = c(withoutCMA = "patient", withCMA = "patient (& CMA)"),
  title = c(aligned = "Event patterns (all patients aligned)", notaligned =
    "Event patterns"),
  col.cats = rainbow,
  unspecified.category.label = "drug",
  medication.groups.to.plot = NULL,
  medication.groups.separator.show = TRUE,
  medication.groups.separator.lty = "solid",
  medication.groups.separator.lwd = 2,
  medication.groups.separator.color = "blue",
  medication.groups.allother.label = "*",
  lty.event = "solid",
  lwd.event = 2,
  pch.start.event = 15,
  pch.end.event = 16,
  plot.events.vertically.displaced = TRUE,
  print.dose = FALSE,
  cex.dose = 0.75,
  print.dose.outline.col = "white",
  print.dose.centered = FALSE,
  plot.dose = FALSE,
  lwd.event.max.dose = 8,
  plot.dose.lwd.across.medication.classes = FALSE,
  col.na = "lightgray",
  col.continuation = "black",
  lty.continuation = "dotted",
  lwd.continuation = 1,
  print.CMA = TRUE,
  CMA.cex = 0.5,
  plot.CMA = TRUE,
  plot.CMA.as.histogram = TRUE,
  plot.partial.CMAs.as = c("stacked", "overlapping", "timeseries")[1],
  plot.partial.CMAs.as.stacked.col.bars = "gray90",
  plot.partial.CMAs.as.stacked.col.border = "gray30",
  plot.partial.CMAs.as.stacked.col.text = "black",
  plot.partial.CMAs.as.timeseries.vspace = 7,
  plot.partial.CMAs.as.timeseries.start.from.zero = TRUE,
  plot.partial.CMAs.as.timeseries.col.dot = "darkblue",
  plot.partial.CMAs.as.timeseries.col.interval = "gray70",
  plot.partial.CMAs.as.timeseries.col.text = "firebrick",
  plot.partial.CMAs.as.timeseries.interval.type = c("none", "segments", "arrows",
    "lines", "rectangles")[2],
  plot.partial.CMAs.as.timeseries.lwd.interval = 1,
  plot.partial.CMAs.as.timeseries.alpha.interval = 0.25,
  plot.partial.CMAs.as.timeseries.show.0perc = TRUE,
  plot.partial.CMAs.as.timeseries.show.100perc = FALSE,
  plot.partial.CMAs.as.overlapping.alternate = TRUE,
  plot.partial.CMAs.as.overlapping.col.interval = "gray70",
  plot.partial.CMAs.as.overlapping.col.text = "firebrick",
  CMA.plot.ratio = 0.1,
  CMA.plot.col = "lightgreen",
  CMA.plot.border = "darkgreen",
  CMA.plot.bkg = "aquamarine",
  CMA.plot.text = CMA.plot.border,
  highlight.followup.window = TRUE,
  followup.window.col = "green",
  highlight.observation.window = TRUE,
  observation.window.col = "yellow",
  observation.window.opacity = 0.3,
  alternating.bands.cols = c("white", "gray95"),
  bw.plot = FALSE,
  force.draw.text = FALSE,
  min.plot.size.in.characters.horiz = 0,
  min.plot.size.in.characters.vert = 0,
  max.patients.to.plot = 100,
  export.formats = NULL,
  export.formats.fileprefix = "AdhereR-plot",
  export.formats.height = NA,
  export.formats.width = NA,
  export.formats.save.svg.placeholder = TRUE,
  export.formats.svg.placeholder.type = c("jpg", "png", "webp")[2],
  export.formats.svg.placeholder.embed = FALSE,
  export.formats.html.template = NULL,
  export.formats.html.javascript = NULL,
  export.formats.html.css = NULL,
  export.formats.directory = NA,
  generate.R.plot = TRUE,
  suppress.warnings = FALSE,
  ...
)

\method{plot}{CMA_sliding_window}(
  x,
  patients.to.plot = NULL,
  duration = NA,
  align.all.patients = FALSE,
  align.first.event.at.zero = TRUE,
  show.period = c("dates", "days")[2],
  period.in.days = 90,
  show.legend = TRUE,
  legend.x = "right",
  legend.y = "bottom",
  legend.bkg.opacity = 0.5,
  legend.cex = 0.75,
  legend.cex.title = 1,
  cex = 1,
  cex.axis = 0.75,
  cex.lab = 1,
  show.cma = TRUE,
  xlab = c(dates = "Date", days = "Days"),
  ylab = c(withoutCMA = "patient", withCMA = "patient (& CMA)"),
  title = c(aligned = "Event patterns (all patients aligned)", notaligned =
    "Event patterns"),
  col.cats = rainbow,
  unspecified.category.label = "drug",
  medication.groups.to.plot = NULL,
  medication.groups.separator.show = TRUE,
  medication.groups.separator.lty = "solid",
  medication.groups.separator.lwd = 2,
  medication.groups.separator.color = "blue",
  medication.groups.allother.label = "*",
  lty.event = "solid",
  lwd.event = 2,
  pch.start.event = 15,
  pch.end.event = 16,
  plot.events.vertically.displaced = TRUE,
  print.dose = FALSE,
  cex.dose = 0.75,
  print.dose.outline.col = "white",
  print.dose.centered = FALSE,
  plot.dose = FALSE,
  lwd.event.max.dose = 8,
  plot.dose.lwd.across.medication.classes = FALSE,
  col.na = "lightgray",
  col.continuation = "black",
  lty.continuation = "dotted",
  lwd.continuation = 1,
  print.CMA = TRUE,
  CMA.cex = 0.5,
  plot.CMA = TRUE,
  plot.CMA.as.histogram = TRUE,
  plot.partial.CMAs.as = c("stacked", "overlapping", "timeseries")[1],
  plot.partial.CMAs.as.stacked.col.bars = "gray90",
  plot.partial.CMAs.as.stacked.col.border = "gray30",
  plot.partial.CMAs.as.stacked.col.text = "black",
  plot.partial.CMAs.as.timeseries.vspace = 7,
  plot.partial.CMAs.as.timeseries.start.from.zero = TRUE,
  plot.partial.CMAs.as.timeseries.col.dot = "darkblue",
  plot.partial.CMAs.as.timeseries.col.interval = "gray70",
  plot.partial.CMAs.as.timeseries.col.text = "firebrick",
  plot.partial.CMAs.as.timeseries.interval.type = c("none", "segments", "arrows",
    "lines", "rectangles")[2],
  plot.partial.CMAs.as.timeseries.lwd.interval = 1,
  plot.partial.CMAs.as.timeseries.alpha.interval = 0.25,
  plot.partial.CMAs.as.timeseries.show.0perc = TRUE,
  plot.partial.CMAs.as.timeseries.show.100perc = FALSE,
  plot.partial.CMAs.as.overlapping.alternate = TRUE,
  plot.partial.CMAs.as.overlapping.col.interval = "gray70",
  plot.partial.CMAs.as.overlapping.col.text = "firebrick",
  CMA.plot.ratio = 0.1,
  CMA.plot.col = "lightgreen",
  CMA.plot.border = "darkgreen",
  CMA.plot.bkg = "aquamarine",
  CMA.plot.text = CMA.plot.border,
  highlight.followup.window = TRUE,
  followup.window.col = "green",
  highlight.observation.window = TRUE,
  observation.window.col = "yellow",
  observation.window.opacity = 0.3,
  alternating.bands.cols = c("white", "gray95"),
  bw.plot = FALSE,
  force.draw.text = FALSE,
  min.plot.size.in.characters.horiz = 0,
  min.plot.size.in.characters.vert = 0,
  max.patients.to.plot = 100,
  export.formats = NULL,
  export.formats.fileprefix = "AdhereR-plot",
  export.formats.height = NA,
  export.formats.width = NA,
  export.formats.save.svg.placeholder = TRUE,
  export.formats.svg.placeholder.type = c("jpg", "png", "webp")[2],
  export.formats.svg.placeholder.embed = FALSE,
  export.formats.html.template = NULL,
  export.formats.html.javascript = NULL,
  export.formats.html.css = NULL,
  export.formats.directory = NA,
  generate.R.plot = TRUE,
  suppress.warnings = FALSE,
  ...
)
}
\arguments{
\item{x}{A \emph{\code{CMA0}} or derived object, representing the CMA to
plot}

\item{patients.to.plot}{A vector of \emph{strings} containing the list of
patient IDs to plot (a subset of those in the \code{cma} object), or
\code{NULL} for all}

\item{duration}{A \emph{number}, the total duration (in days) of the whole
period to plot; in \code{NA} it is automatically determined from the event
data such that the whole dataset fits.}

\item{align.all.patients}{\emph{Logical}, should all patients be aligned
(i.e., the actual dates are discarded and all plots are relative to the
earliest date)?}

\item{align.first.event.at.zero}{\emph{Logical}, should the first event be
placed at the origin of the time axis (at 0)?}

\item{show.period}{A \emph{string}, if "dates" show the actual dates at the
regular grid intervals, while for "days" (the default) shows the days since
the beginning; if \code{align.all.patients == TRUE}, \code{show.period} is
taken as "days".}

\item{period.in.days}{The \emph{number} of days at which the regular grid is
drawn (or 0 for no grid).}

\item{show.legend}{\emph{Logical}, should the legend be drawn?}

\item{legend.x}{The position of the legend on the x axis; can be "left",
"right" (default), or a \emph{numeric} value.}

\item{legend.y}{The position of the legend on the y axis; can be "bottom"
(default), "top", or a \emph{numeric} value.}

\item{legend.bkg.opacity}{A \emph{number} between 0.0 and 1.0 specifying the
opacity of the legend background.}

\item{legend.cex, legend.cex.title}{The legend and legend title font sizes.}

\item{cex, cex.axis, cex.lab}{\emph{numeric} values specifying the cex of the
various types of text.}

\item{show.cma}{\emph{Logical}, should the CMA type be shown in the title?}

\item{xlab}{Named vector of x-axis labels to show for the two types of periods
("days" and "dates"), or a single value for both, or \code{NULL} for nothing.}

\item{ylab}{Named vector of y-axis labels to show without and with CMA estimates,
or a single value for both, or \code{NULL} for nonthing.}

\item{title}{Named vector of titles to show for and without alignment, or a
single value for both, or \code{NULL} for nonthing.}

\item{col.cats}{A \emph{color} or a \emph{function} that specifies the single
colour or the colour palette used to plot the different medication; by
default \code{rainbow}, but we recommend, whenever possible, a
colorblind-friendly palette such as \code{viridis} or \code{colorblind_pal}.}

\item{unspecified.category.label}{A \emph{string} giving the name of the
unspecified (generic) medication category.}

\item{medication.groups.to.plot}{the names of the medication groups to plot or
\code{NULL} (the default) for all.}

\item{medication.groups.separator.show}{a \emph{boolean}, if \code{TRUE} (the
default) visually mark the medication groups the belong to the same patient,
using horizontal lines and alternating vertical lines.}

\item{medication.groups.separator.lty, medication.groups.separator.lwd, medication.groups.separator.color}{graphical parameters (line type, line width and colour describing the visual
marking og medication groups as beloning to the same patient.}

\item{medication.groups.allother.label}{a \emph{string} giving the label to
use for the implicit \code{__ALL_OTHERS__} medication group (defaults to "*").}

\item{lty.event, lwd.event, pch.start.event, pch.end.event}{The style of the
event (line style, width, and start and end symbols).}

\item{plot.events.vertically.displaced}{Should consecutive events be plotted
on separate rows (i.e., separated vertically, the default) or on the same row?}

\item{print.dose, cex.dose, print.dose.outline.col, print.dose.centered}{Print daily
dose as a number and, if so, how (color, size, position...).}

\item{plot.dose, lwd.event.max.dose, plot.dose.lwd.across.medication.classes}{Show dose through the width of the event lines and, if so, what the maximum
width should be, and should this maximum be by medication class or overall.}

\item{col.na}{The colour used for missing event data.}

\item{col.continuation, lty.continuation, lwd.continuation}{The color, style
and width of the contuniation lines connecting consecutive events.}

\item{print.CMA}{\emph{Logical}, should the CMA values be printed?}

\item{CMA.cex}{... and, if printed, what cex (\emph{numeric}) to use?}

\item{plot.CMA}{\emph{Logical}, should the distribution of the CMA values
across episodes/sliding windows be plotted? If \code{TRUE} (the default), the
distribution is shown on the left-hand side of the plot, otherwise it is not.}

\item{plot.CMA.as.histogram}{\emph{Logical}, should the CMA plot be a
histogram or a (truncated) density plot? Please note that it is TRUE by
deafult for CMA_per_episode and FALSE for CMA_sliding_window, because
usually there are more sliding windows than episodes. Also, the density
estimate cannot be estimated for less than three different values.}

\item{plot.partial.CMAs.as}{Should the partial CMAs be plotted? Possible values
are "stacked", "overlapping" or "timeseries", or \code{NULL} for no partial
CMA plots. Please note that \code{plot.CMA} and \code{plot.partial.CMAs.as}
are independent of each other.}

\item{plot.partial.CMAs.as.stacked.col.bars, plot.partial.CMAs.as.stacked.col.border, plot.partial.CMAs.as.stacked.col.text}{If plotting the partial CMAs as stacked bars, define their graphical attributes.}

\item{plot.partial.CMAs.as.timeseries.vspace, plot.partial.CMAs.as.timeseries.start.from.zero, plot.partial.CMAs.as.timeseries.col.dot, plot.partial.CMAs.as.timeseries.col.interval, plot.partial.CMAs.as.timeseries.col.text, plot.partial.CMAs.as.timeseries.interval.type, plot.partial.CMAs.as.timeseries.lwd.interval, plot.partial.CMAs.as.timeseries.alpha.interval, plot.partial.CMAs.as.timeseries.show.0perc, plot.partial.CMAs.as.timeseries.show.100perc}{If plotting the partial CMAs as imeseries, these are their graphical attributes.}

\item{plot.partial.CMAs.as.overlapping.alternate, plot.partial.CMAs.as.overlapping.col.interval, plot.partial.CMAs.as.overlapping.col.text}{If plotting the partial CMAs as overlapping segments, these are their
graphical attributes.}

\item{CMA.plot.ratio}{A \emph{number}, the proportion of the total horizontal
plot space to be allocated to the CMA plot.}

\item{CMA.plot.col, CMA.plot.border, CMA.plot.bkg, CMA.plot.text}{\emph{Strings}
giving the colours of the various components of the CMA plot.}

\item{highlight.followup.window}{\emph{Logical}, should the follow-up window
be plotted?}

\item{followup.window.col}{The follow-up window colour.}

\item{highlight.observation.window}{\emph{Logical}, should the observation
window be plotted?}

\item{observation.window.col, observation.window.opacity}{Attributes of the observation window (colour, transparency).}

\item{alternating.bands.cols}{The colors of the alternating vertical bands
distinguishing the patients; can be \code{NULL} = don't draw the bandes;
or a vector of colors.}

\item{bw.plot}{\emph{Logical}, should the plot use grayscale only (i.e., the
\code{\link[grDevices]{gray.colors}} function)?}

\item{force.draw.text}{\emph{Logical}, if \code{TRUE}, always draw text even
if too big or too small}

\item{min.plot.size.in.characters.horiz, min.plot.size.in.characters.vert}{\emph{Numeric}, the minimum size of the plotting surface in characters;
horizontally (min.plot.size.in.characters.horiz) refers to the the whole
duration of the events to plot; vertically (min.plot.size.in.characters.vert)
refers to a single event. If the plotting is too small, possible solutions
might be: if within \code{RStudio}, try to enlarge the "Plots" panel, or
(also valid outside \code{RStudio} but not if using \code{RStudio server}
start a new plotting device (e.g., using \code{X11()}, \code{quartz()}
or \code{windows()}, depending on OS) or (works always) save to an image
(e.g., \code{jpeg(...); ...; dev.off()}) and display it in a viewer.}

\item{max.patients.to.plot}{\emph{Numeric}, the maximum patients to attempt
to plot.}

\item{export.formats}{a \emph{string} giving the formats to export the figure
to (by default \code{NULL}, meaning no exporting); can be any combination of
"svg" (just an \code{SVG} file), "html" (\code{SVG} + \code{HTML} + \code{CSS}
+ \code{JavaScript}, all embedded within one \code{HTML} document), "jpg",
"png", "webp", "ps" or "pdf".}

\item{export.formats.fileprefix}{a \emph{string} giving the file name prefix
for the exported formats (defaults to "AdhereR-plot").}

\item{export.formats.height, export.formats.width}{\emph{numbers} giving the
desired dimensions (in pixels) for the exported figure (defaults to sane
values if \code{NA}).}

\item{export.formats.save.svg.placeholder}{a \emph{logical}, if TRUE, save an
image placeholder of type given by \code{export.formats.svg.placeholder.type}
for the \code{SVG} image.}

\item{export.formats.svg.placeholder.type}{a \emph{string}, giving the type of
placeholder for the \code{SVG} image to save; can be "jpg",
"png" (the default) or "webp".}

\item{export.formats.svg.placeholder.embed}{a \emph{logical}, if \code{TRUE},
embed the placeholder image in the HTML document (if any) using \code{base64}
encoding, otherwise (the default) leave it as an external image file (works
only when an \code{HTML} document is exported and only for \code{JPEG} or
\code{PNG} images.}

\item{export.formats.html.template, export.formats.html.javascript, export.formats.html.css}{\emph{character strings} or \code{NULL} (the default) giving the path to the
\code{HTML}, \code{JavaScript} and \code{CSS} templates, respectively, to be
used when generating the HTML+CSS semi-interactive plots; when \code{NULL},
the default ones included with the package will be used. If you decide to define
new templates please use the default ones for inspiration and note that future
version are not guaranteed to be backwards compatible!}

\item{export.formats.directory}{a \emph{string}; if exporting, which directory
to export to; if \code{NA} (the default), creates the files in a temporary
directory.}

\item{generate.R.plot}{a \emph{logical}, if \code{TRUE} (the default),
generate the standard (base \code{R}) plot for plotting within \code{R}.}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}

\item{...}{other parameters (to be passed to the estimation and plotting of
the simple CMA)}
}
\description{
Plots the event data and the estimated CMA per treatment episode and sliding
window, respectively.
}
\details{
The x-axis represents time (either in days since the earliest date or as
actual dates), with consecutive events represented as ascending on the y-axis.

Each event is represented as a segment with style \code{lty.event} and line
width \code{lwd.event} starting with a \code{pch.start.event} and ending with
a \code{pch.end.event} character, coloured with a unique color as given by
\code{col.cats}, extending from its start date until its end date.
Consecutive events are thus represented on consecutive levels of the y-axis
and are connected by a "continuation" line with \code{col.continuation}
colour, \code{lty.continuation} style and \code{lwd.continuation} width;
these continuation lines are purely visual guides helping to perceive the
sequence of events, and carry no information about the avilability of
medicine in this interval.

Above these, the treatment episodes or the sliding windows are represented in
a stacked manner from the earlieast (left, bottom of the stack) to the latest
(right, top of the stack), each showing the CMA as percent fill (capped at
100\% even if CMA values may be higher) and also as text.

The follow-up and the observation windows are plotted as empty an rectangle
and as shaded rectangle, respectively (for some CMAs the observation window
might be adjusted in which case the adjustment may also be plotted using a
different shading).

The kernel density ("smoothed histogram") of the CMA estimates across
treatment episodes/sliding windows (if more than 2) can be visually
represented as well in the left side of the figure (NB, their horizontal
scales may be different across patients).

When several patients are displayed on the same plot, they are organized
vertically, and alternating bands (white and gray) help distinguish
consecutive patients.
Implicitely, all patients contained in the \code{cma} object will be plotted,
but the \code{patients.to.plot} parameter allows the selection of a subset
of patients.

Finally, the y-axis shows the patient ID and possibly the CMA estimate as
well.

Any not explicitely defined arguments are passed to the simple CMA estimation
and plotting function; therefore, for more info about possible estimation
parameters plese see the help for the appropriate simple CMA, and for possible
aesthetic tweaks, please see the help for their plotting.
}
\examples{
\dontrun{
cmaW <- CMA_sliding_window(CMA=CMA1,
                        data=med.events,
                        ID.colname="PATIENT_ID",
                        event.date.colname="DATE",
                        event.duration.colname="DURATION",
                        event.daily.dose.colname="PERDAY",
                        medication.class.colname="CATEGORY",
                        carry.only.for.same.medication=FALSE,
                        consider.dosage.change=FALSE,
                        followup.window.start=0,
                        observation.window.start=0,
                        observation.window.duration=365,
                        sliding.window.start=0,
                        sliding.window.start.unit="days",
                        sliding.window.duration=90,
                        sliding.window.duration.unit="days",
                        sliding.window.step.duration=7,
                        sliding.window.step.unit="days",
                        sliding.window.no.steps=NA,
                        date.format="\%m/\%d/\%Y"
                       );
plot(cmaW, patients.to.plot=c("1","2"));
cmaE <- CMA_per_episode(CMA=CMA1,
                        data=med.events,
                        ID.colname="PATIENT_ID",
                        event.date.colname="DATE",
                        event.duration.colname="DURATION",
                        event.daily.dose.colname="PERDAY",
                        medication.class.colname="CATEGORY",
                        carry.only.for.same.medication=FALSE,
                        consider.dosage.change=FALSE,
                        followup.window.start=0,
                        observation.window.start=0,
                        observation.window.duration=365,
                        date.format="\%m/\%d/\%Y"
                       );
plot(cmaE, patients.to.plot=c("1","2"));}
}
\seealso{
See the simple CMA estimation \code{\link[AdhereR]{CMA1}}
to \code{\link[AdhereR]{CMA9}} and plotting \code{\link[AdhereR]{plot.CMA1}}
functions for extra parameters.
}
