% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{CMA_per_episode}
\alias{CMA_per_episode}
\title{CMA_per_episode constructor.}
\usage{
CMA_per_episode(CMA.to.apply, data, treat.epi = NULL, ID.colname = NA,
  event.date.colname = NA, event.duration.colname = NA,
  event.daily.dose.colname = NA, medication.class.colname = NA,
  carry.only.for.same.medication = NA, consider.dosage.change = NA,
  medication.change.means.new.treatment.episode = TRUE,
  dosage.change.means.new.treatment.episode = FALSE,
  maximum.permissible.gap = 180,
  maximum.permissible.gap.unit = c("days", "weeks", "months", "years",
  "percent")[1], followup.window.start = 0,
  followup.window.start.unit = c("days", "weeks", "months", "years")[1],
  followup.window.duration = 365 * 2,
  followup.window.duration.unit = c("days", "weeks", "months",
  "years")[1], observation.window.start = 0,
  observation.window.start.unit = c("days", "weeks", "months",
  "years")[1], observation.window.duration = 365 * 2,
  observation.window.duration.unit = c("days", "weeks", "months",
  "years")[1], date.format = "\%m/\%d/\%Y",
  summary = "CMA per treatment episode",
  event.interval.colname = "event.interval",
  gap.days.colname = "gap.days",
  force.NA.CMA.for.failed.patients = TRUE, parallel.backend = c("none",
  "multicore", "snow", "snow(SOCK)", "snow(MPI)", "snow(NWS)")[1],
  parallel.threads = "auto", suppress.warnings = FALSE, ...)
}
\arguments{
\item{CMA.to.apply}{A \emph{string} giving the name of the CMA function (1 to
9) that will be computed for each treatment episode.}

\item{data}{A \emph{\code{data.frame}} containing the events (prescribing or
dispensing) used to compute the CMA. Must contain, at a minimum, the patient
unique ID, the event date and duration, and might also contain the daily
dosage and medication type (the actual column names are defined in the
following four parameters).}

\item{treat.epi}{A \emph{\code{data.frame}} containing the treatment episodes.
Must contain the patient ID (as given in \code{ID.colname}), the episode unique ID
(increasing sequentially, \code{episode.ID}), the episode start date
(\code{episode.start}), the episode duration in days (\code{episode.duration}),
and the episode end date (\code{episode.end}).}

\item{ID.colname}{A \emph{string}, the name of the column in \code{data}
containing the unique patient ID; must be present.}

\item{event.date.colname}{A \emph{string}, the name of the column in
\code{data} containing the start date of the event (in the format given in
the \code{date.format} parameter); must be present.}

\item{event.duration.colname}{A \emph{string}, the name of the column in
\code{data} containing the event duration (in days); must be present.}

\item{event.daily.dose.colname}{A \emph{string}, the name of the column in
\code{data} containing the prescribed daily dose, or \code{NA} if not defined.}

\item{medication.class.colname}{A \emph{string}, the name of the column in
\code{data} containing the medication type, or \code{NA} if not defined.}

\item{carry.only.for.same.medication}{\emph{Logical}, if \code{TRUE}, the
carry-over applies only across medication of the same type; valid only for
CMAs 5 to 9, in which case it is coupled (i.e., the same value is used for
computing the treatment episodes and the CMA on each treatment episode).}

\item{consider.dosage.change}{\emph{Logical}, if \code{TRUE}, the carry-over
is adjusted to also reflect changes in dosage; valid only for CMAs 5 to 9, in
which case it is coupled (i.e., the same value is used for computing the
treatment episodes and the CMA on each treatment episode).}

\item{medication.change.means.new.treatment.episode}{\emph{Logical}, should a
change in medication automatically start a new treatment episode?}

\item{dosage.change.means.new.treatment.episode}{\emph{Logical}, should a
change in dosage automatically start a new treatment episode?}

\item{maximum.permissible.gap}{The \emph{number} of units given by
\code{maximum.permissible.gap.unit} representing the maximum duration of
permissible gaps between treatment episodes (can also be a percent, see
\code{maximum.permissible.gap.unit} for details).}

\item{maximum.permissible.gap.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"}, \emph{"years"} or \emph{"percent"}, and
represents the time units that \code{maximum.permissible.gap} refers to;
if \emph{percent}, then  \code{maximum.permissible.gap} is interpreted as a
percent (can be greater than 100\%) of the duration of the current
prescription.}

\item{followup.window.start}{If a \emph{\code{Date}} object, it represents
the actual start date of the follow-up window; if a \emph{string} it is the
name of the column in \code{data} containing the start date of the follow-up
window either as the numbers of \code{followup.window.start.unit} units after
the first event (the column must be of type \code{numeric}) or as actual
dates (in which case the column must be of type \code{Date}); if a
\emph{number} it is the number of time units defined in the
\code{followup.window.start.unit} parameter after the begin of the
participant's first event; or \code{NA} if not defined.}

\item{followup.window.start.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.start} refers to (when a number), or
\code{NA} if not defined.}

\item{followup.window.duration}{either a \emph{number} representing the
duration of the follow-up window in the time units given in
\code{followup.window.duration.unit}, or a \emph{string} giving the column
containing these numbers. Should represent a period for which relevant
medication events are recorded accurately (e.g. not extend after end of
relevant treatment, loss-to-follow-up or change to a health care provider
not covered by the database).}

\item{followup.window.duration.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.duration} refers to, or \code{NA} if not
defined.}

\item{observation.window.start, observation.window.start.unit, observation.window.duration, observation.window.duration.unit}{the definition of the observation window
(see the follow-up window parameters above for details).}

\item{date.format}{A \emph{string} giving the format of the dates used in the
\code{data} and the other parameters; see the \code{format} parameters of the
\code{\link[base]{as.Date}} function for details (NB, this concerns only the
dates given as strings and not as \code{Date} objects).}

\item{summary}{Metadata as a \emph{string}, briefly describing this CMA.}

\item{event.interval.colname}{A \emph{string}, the name of a newly-created
column storing the number of days between the start of the current event and
the start of the next one; the default value "event.interval" should be
changed only if there is a naming conflict with a pre-existing
"event.interval" column in \code{event.info}.}

\item{gap.days.colname}{A \emph{string}, the name of a newly-created column
storing the number of days when medication was not available (i.e., the
"gap days"); the default value "gap.days" should be changed only if there is
a naming conflict with a pre-existing "gap.days" column in \code{event.info}.}

\item{force.NA.CMA.for.failed.patients}{\emph{Logical} describing how the
patients for which the CMA estimation fails are treated: if \code{TRUE}
they are returned with an \code{NA} CMA estimate, while for
\code{FALSE} they are omitted.}

\item{parallel.backend}{Can be "none" (the default) for single-threaded
execution, "multicore"  (using \code{mclapply} in package \code{parallel})
for multicore processing (NB. not currently implemented on MS Windows and
automatically falls back on "snow" on this platform),  or "snow",
"snow(SOCK)" (equivalent to "snow"), "snow(MPI)" or "snow(NWS)" specifying
various types of SNOW clusters (can be on the local machine or more complex
setups -- please see the documentation of package \code{snow} for details;
the last two require packages \code{Rmpi} and \code{nws}, respectively, not
automatically installed with \code{AdhereR}).}

\item{parallel.threads}{Can be "auto" (for \code{parallel.backend} ==
"multicore", defaults to the number of cores in the system as given by
\code{options("cores")}, while for \code{parallel.backend} == "snow",
defaults to 2), a strictly positive integer specifying the number of parallel
threads, or a more complex specification of the SNOW cluster nodes for
\code{parallel.backend} == "snow" (see the documentation of package
\code{snow} for details).}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}

\item{...}{other possible parameters}
}
\value{
An \code{S3} object of class \code{CMA_per_episode} with the
following fields:
\itemize{
 \item \code{data} The actual event data, as given by the \code{data}
 parameter.
 \item \code{ID.colname} the name of the column in \code{data} containing the
 unique patient ID, as given by the \code{ID.colname} parameter.
 \item \code{event.date.colname} the name of the column in \code{data}
 containing the start date of the event (in the format given in the
 \code{date.format} parameter), as given by the \code{event.date.colname}
 parameter.
 \item \code{event.duration.colname} the name of the column in \code{data}
 containing the event duration (in days), as given by the
 \code{event.duration.colname} parameter.
 \item \code{event.daily.dose.colname} the name of the column in \code{data}
 containing the prescribed daily dose, as given by the
 \code{event.daily.dose.colname} parameter.
 \item \code{medication.class.colname} the name of the column in \code{data}
 containing the classes/types/groups of medication, as given by the
 \code{medication.class.colname} parameter.
 \item \code{carry.only.for.same.medication} whether the carry-over applies
 only across medication of the same type, as given by the
 \code{carry.only.for.same.medication} parameter.
 \item \code{consider.dosage.change} whether the carry-over is adjusted to
 reflect changes in dosage, as given by the \code{consider.dosage.change}
 parameter.
 \item \code{followup.window.start} the beginning of the follow-up window, as
 given by the \code{followup.window.start} parameter.
 \item \code{followup.window.start.unit} the time unit of the
 \code{followup.window.start}, as given by the
 \code{followup.window.start.unit} parameter.
 \item \code{followup.window.duration} the duration of the follow-up window,
 as given by the \code{followup.window.duration} parameter.
 \item \code{followup.window.duration.unit} the time unit of the
 \code{followup.window.duration}, as given by the
 \code{followup.window.duration.unit} parameter.
 \item \code{observation.window.start} the beginning of the observation
 window, as given by the \code{observation.window.start} parameter.
 \item \code{observation.window.start.unit} the time unit of the
 \code{observation.window.start}, as given by the
 \code{observation.window.start.unit} parameter.
 \item \code{observation.window.duration} the duration of the observation
 window, as given by the \code{observation.window.duration} parameter.
 \item \code{observation.window.duration.unit} the time unit of the
 \code{observation.window.duration}, as given by the
 \code{observation.window.duration.unit} parameter.
 \item \code{date.format} the format of the dates, as given by the
 \code{date.format} parameter.
 \item \code{summary} the metadata, as given by the \code{summary} parameter.
 \item \code{event.info} the \code{data.frame} containing the event info
 (irrelevant for most users; see \code{\link{compute.event.int.gaps}} for
 details).
 \item \code{computed.CMA} the class name of the computed CMA.
 \item \code{CMA} the \code{data.frame} containing the actual \code{CMA}
 estimates for each participant (the \code{ID.colname} column) and treatment
 episode, with columns:
   \itemize{
     \item \code{ID.colname} the patient ID as given by the \code{ID.colname}
     parameter.
     \item \code{episode.ID} the unique treatment episode ID (within
     patients).
     \item \code{episode.start} the treatment episode's start date (as a
     \code{Date} object).
     \item \code{end.episode.gap.days} the corresponding gap days of the last
     event in this episode.
     \item \code{episode.duration} the treatment episode's duration in days.
     \item \code{episode.end} the treatment episode's end date (as a
     \code{Date} object).
     \item \code{CMA} the treatment episode's estimated CMA.
   }
}
}
\description{
Applies a given CMA to each treatment episode and constructs a
CMA_per_episode object.
}
\details{
\code{CMA_per_episode} first identifies the treatment episodes for the whole
follo-up window (using the \code{\link{compute.treatment.episodes}} function),
and then computes the given "simple" CMA for each treatment episode that
intersects with the observation window. NB: the CMA is computed for the
period of the episode that is part of the observations window; thus, if an
episode starts earlier or ends later than the observation window, CMA will
be computed for a section of that episode.
Thus, as opposed to the "simple" CMAs 1 to 9, it returns a set of CMAs, with
possibly more than one element.

It is highly similar to \code{\link{CMA_sliding_window}} which computes a CMA
for a set of sliding windows.
}
\examples{
\dontrun{
cmaE <- CMA_per_episode(CMA="CMA1",
                        data=med.events,
                        ID.colname="PATIENT_ID",
                        event.date.colname="DATE",
                        event.duration.colname="DURATION",
                        event.daily.dose.colname="PERDAY",
                        medication.class.colname="CATEGORY",
                        carry.only.for.same.medication=FALSE,
                        consider.dosage.change=FALSE,
                        followup.window.start=0,
                        observation.window.start=0,
                        observation.window.duration=365,
                        date.format="\%m/\%d/\%Y"
                       );}
}
\seealso{
\code{\link{CMA_sliding_window}} is very similar, computing a
"simple" CMA for each of a set of same-size sliding windows.
The "simple" CMAs that can be computed comprise \code{\link{CMA1}},
\code{\link{CMA2}}, \code{\link{CMA3}}, \code{\link{CMA4}},
\code{\link{CMA5}}, \code{\link{CMA6}}, \code{\link{CMA7}},
\code{\link{CMA8}}, \code{\link{CMA9}}, as well as user-defined classes
derived from \code{\link{CMA0}} that have a \code{CMA} component giving the
estimated CMA per patient as a \code{data.frame}.
}
