% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMixturesAndBoundaries.R
\name{PlotMixturesAndBoundaries}
\alias{PlotMixturesAndBoundaries}
\title{Shows GMM with Boundaries}
\usage{
PlotMixturesAndBoundaries(Data, Means, SDs, Weights,
  IsLogDistribution = rep(FALSE, length(Means)), SingleColor = "blue",
  MixtureColor = "red", DataColor = "black",
  BoundaryColor = "magenta", xlab, ylab, ...)
}
\arguments{
\item{Data}{vector (1:N) of data points}

\item{Means}{vector[1:L] of Means of Gaussians (of GMM),L == Number of Gaussians}

\item{SDs}{vector of standard deviations, estimated Gaussian Kernels, has to be the same length as Means}

\item{Weights}{vector of relative number of points in Gaussians (prior probabilities), has to be the same length as Means}

\item{IsLogDistribution}{Optional, ==1 if distribution(i) is a LogNormal, default vector of zeros of length 1:L}

\item{SingleColor}{Optional, Color for line plot of all the single gaussians, default magenta}

\item{MixtureColor}{Optional, Color of line plot for the mixture, default red}

\item{DataColor}{Optional, Color of line plot for the data, default black}

\item{BoundaryColor}{Optional, Color of bayesian boundaries}

\item{xlab}{Optional, x label, see plot}

\item{ylab}{Optional, y label, see plot}

\item{...}{Optional, see plot for plot properties and for SingleGausses PlotMixtures}
}
\description{
Plots Gaussian Mixture Model with Bayes decision boundaries, such that: \cr
 \cr
 Black is the PDE of Data \cr
 \cr
 Red is color of the GMM \cr
 \cr
 Magenta are the Bayes boundaries
}
\details{
you may also set SingleGausses=T than components of the mixture in blue will be shown.
}
\author{
Michael Thrun

\strong{See Also}

BayesDecisionBoundaries,PlotMixtures
}
