% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActivePathways.r
\name{columnSignificance}
\alias{columnSignificance}
\title{Determine which terms are found to be significant using each column
individually.}
\usage{
columnSignificance(
  scores,
  gmt,
  background,
  cutoff,
  significant,
  correction.method,
  pvals
)
}
\arguments{
\item{scores}{A numerical matrix of p-values where each row is a gene and
each column represents an omics dataset (evidence). Rownames correspond to the genes 
and colnames to the datasets. All values must be 0<=p<=1. We recommend converting 
missing values to ones.}

\item{gmt}{A GMT object to be used for enrichment analysis. If a filename, a
GMT object will be read from the file.}

\item{background}{A character vector of gene names to be used as a
statistical background. By default, the background is all genes that appear
in \code{gmt}.}

\item{cutoff}{A maximum merged p-value for a gene to be used for analysis.
Any genes with merged, unadjusted \code{p > significant} will be discarded 
before testing.}

\item{significant}{Significance cutoff for selecting enriched pathways. Pathways with
\code{adjusted.p.val < significant} will be selected as results.}

\item{correction.method}{Statistical method to correct p-values. See
\code{\link[stats]{p.adjust}} for details.}

\item{pvals}{p-value for the pathways calculated by ActivePathways}
}
\value{
a data.table with columns 'term.id' and a column for each column
in \code{scores}, indicating whether each term (pathway) was found to be
significant or not when considering only that column. For each term, 
either report the list of related genes if that term was significant, or NA if not.
}
\description{
Determine which terms are found to be significant using each column
individually.
}
